/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.security.EncryptionStrategyNotFoundException;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityFilter;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.SecurityProvider;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.security.MuleSecurityManager;
import org.mule.transformer.TransformerTemplate;
import org.mule.util.StringUtils;

public abstract class AbstractSecurityFilter
implements MuleContextAware,
SecurityFilter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected SecurityManager securityManager;
    protected MuleContext muleContext;
    private String securityProviders;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public final void initialise() throws InitialisationException {
        if (this.securityManager == null) {
            this.securityManager = this.muleContext.getSecurityManager();
        }
        if (this.securityManager == null) {
            throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Initialisable)this);
        }
        if (this.securityProviders != null) {
            String[] securityProviders;
            MuleSecurityManager localManager = new MuleSecurityManager();
            for (String sp : securityProviders = StringUtils.splitAndTrim(this.securityProviders, ",")) {
                SecurityProvider provider = this.securityManager.getProvider(sp);
                if (provider == null) {
                    throw new InitialisationException(CoreMessages.objectNotRegistered("Security Provider", sp), (Initialisable)this);
                }
                localManager.addProvider(provider);
            }
            this.securityManager = localManager;
        }
        this.doInitialise();
    }

    protected void doInitialise() throws InitialisationException {
    }

    public void setSecurityManager(SecurityManager manager) {
        this.securityManager = manager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public String getSecurityProviders() {
        return this.securityProviders;
    }

    public void setSecurityProviders(String providers) {
        this.securityProviders = providers;
    }

    public abstract void doFilter(MuleEvent var1) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException;

    protected void updatePayload(MuleMessage message, final Object payload, MuleEvent event) throws MuleException {
        TransformerTemplate trans = new TransformerTemplate(new TransformerTemplate.TransformerCallback(){

            public Object doTransform(MuleMessage message) throws Exception {
                return payload;
            }
        });
        message.applyTransformers(event, trans);
    }
}

