/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.transformer.Transformer;
import org.mule.construct.SimpleFlowConstruct;
import org.mule.processor.chain.AbstractMessageProcessorChain;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.MessageFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageProcessorChain
extends AbstractMessageProcessorChain {
    protected DefaultMessageProcessorChain(List<MessageProcessor> processors) {
        super(null, processors);
    }

    protected DefaultMessageProcessorChain(MessageProcessor ... processors) {
        super(null, Arrays.asList(processors));
    }

    protected DefaultMessageProcessorChain(String name, List<MessageProcessor> processors) {
        super(name, processors);
    }

    protected DefaultMessageProcessorChain(String name, MessageProcessor ... processors) {
        super(name, Arrays.asList(processors));
    }

    public static MessageProcessorChain from(MessageProcessor messageProcessor) {
        return new DefaultMessageProcessorChain(messageProcessor);
    }

    public static MessageProcessorChain from(MessageProcessor ... messageProcessors) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    public static MessageProcessorChain from(List<MessageProcessor> messageProcessors) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    @Override
    protected MuleEvent doProcess(MuleEvent event) throws MuleException {
        FlowConstruct flowConstruct = event.getFlowConstruct();
        MuleEvent currentEvent = event;
        MuleEvent copy = null;
        Iterator processorIterator = this.processors.iterator();
        while (processorIterator.hasNext()) {
            MessageProcessor processor = (MessageProcessor)processorIterator.next();
            this.fireNotification(event.getFlowConstruct(), event, processor, 1601);
            if (flowConstruct instanceof SimpleFlowConstruct && processorIterator.hasNext() && this.processorMayReturnNull(processor)) {
                copy = OptimizedRequestContext.criticalSetEvent(currentEvent);
            }
            MuleEvent resultEvent = processor.process(currentEvent);
            this.fireNotification(event.getFlowConstruct(), resultEvent, processor, 1602);
            if (resultEvent != null) {
                currentEvent = resultEvent;
                continue;
            }
            if (flowConstruct instanceof SimpleFlowConstruct && processorIterator.hasNext()) {
                if (copy != null) {
                    currentEvent = copy;
                    continue;
                }
                currentEvent = OptimizedRequestContext.criticalSetEvent(currentEvent);
                continue;
            }
            return null;
        }
        return currentEvent;
    }

    protected boolean processorMayReturnNull(MessageProcessor processor) {
        if (processor instanceof OutboundEndpoint) {
            return !((OutboundEndpoint)processor).getExchangePattern().hasResponse();
        }
        return !(processor instanceof Component) && !(processor instanceof Transformer) && !(processor instanceof MessageFilter);
    }
}

