/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.text.MessageFormat;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.DefaultMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.NamedObject;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.FailedToQueueEventException;
import org.mule.config.QueueProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.management.stats.QueueStatistics;
import org.mule.processor.AsyncWorkListener;
import org.mule.processor.OptionalAsyncInterceptingMessageProcessor;
import org.mule.processor.SedaStageLifecycleManager;
import org.mule.service.Pausable;
import org.mule.service.Resumable;
import org.mule.util.concurrent.WaitableBoolean;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;
import org.mule.work.AbstractMuleEventWork;

public class SedaStageInterceptingMessageProcessor
extends OptionalAsyncInterceptingMessageProcessor
implements Work,
Lifecycle,
Pausable,
Resumable {
    protected static final String QUEUE_NAME_PREFIX = "seda.queue";
    protected QueueProfile queueProfile;
    protected int queueTimeout;
    protected QueueStatistics queueStatistics;
    protected MuleContext muleContext;
    protected String name;
    protected Queue queue;
    private WaitableBoolean running = new WaitableBoolean(false);
    protected SedaStageLifecycleManager lifecycleManager;

    public SedaStageInterceptingMessageProcessor(String name, QueueProfile queueProfile, int queueTimeout, ThreadingProfile threadingProfile, QueueStatistics queueStatistics, MuleContext muleContext) {
        super(threadingProfile, "seda." + name, muleContext.getConfiguration().getShutdownTimeout());
        this.name = name;
        this.queueProfile = queueProfile;
        this.queueTimeout = queueTimeout;
        this.queueStatistics = queueStatistics;
        this.muleContext = muleContext;
        this.lifecycleManager = new SedaStageLifecycleManager(name, this);
    }

    protected void processNextAsync(MuleEvent event) throws MuleException {
        try {
            if (this.isStatsEnabled()) {
                this.queueStatistics.incQueuedEvent();
            }
            this.enqueue(event);
        }
        catch (Exception e) {
            throw new FailedToQueueEventException(CoreMessages.interruptedQueuingEventFor(this.getStageDescription()), event, (Throwable)e);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("MuleEvent added to queue for: " + this.getStageDescription()));
        }
    }

    protected boolean isStatsEnabled() {
        return this.queueStatistics != null && this.queueStatistics.isEnabled();
    }

    protected void enqueue(MuleEvent event) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("{1}: Putting event on queue {2}", this.queue.getName(), this.getStageDescription(), event));
        }
        this.queue.put(event);
    }

    protected MuleEvent dequeue() throws Exception {
        MuleEvent event;
        if (this.queue == null) {
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)MessageFormat.format("{0}: Polling queue {1}, timeout = {2}", this.getStageName(), this.getStageDescription(), this.queueTimeout));
        }
        if ((event = (MuleEvent)this.queue.poll(this.queueTimeout)) != null && this.lifecycleManager.isPhaseComplete("pause")) {
            this.queue.untake(event);
            return null;
        }
        return event;
    }

    public void run() {
        DefaultMuleEvent event = null;
        QueueSession queueSession = this.muleContext.getQueueManager().getQueueSession();
        this.running.set(true);
        while (!this.lifecycleManager.getState().isStopped()) {
            try {
                if (this.lifecycleManager.isPhaseComplete("pause")) {
                    this.waitIfPaused();
                    if (this.lifecycleManager.getState().isStopping()) {
                        if (this.isQueuePersistent() || queueSession == null || this.getQueueSize() <= 0) break;
                        this.logger.warn((Object)CoreMessages.stopPausedSedaStageNonPeristentQueueMessageLoss(this.getQueueSize(), this.getQueueName()));
                        break;
                    }
                }
                if (this.lifecycleManager.getState().isStopping() && (this.isQueuePersistent() || queueSession == null || this.getQueueSize() <= 0)) break;
                event = (DefaultMuleEvent)this.dequeue();
            }
            catch (InterruptedException ie) {
                break;
            }
            catch (Exception e) {
                SystemExceptionHandler exceptionListener = this.muleContext.getExceptionListener();
                if (e instanceof MuleException) {
                    exceptionListener.handleException(e);
                }
                exceptionListener.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.getStageDescription()), event, (Throwable)e));
            }
            if (event == null) continue;
            try {
                if (this.isStatsEnabled()) {
                    this.queueStatistics.decQueuedEvent();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)MessageFormat.format("{0}: Dequeued event from {1}", this.getStageDescription(), this.getQueueName()));
                }
                SedaStageWorker work = new SedaStageWorker(event);
                if (this.doThreading) {
                    this.workManagerSource.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, new AsyncWorkListener(this.next));
                    continue;
                }
                work.run();
            }
            catch (Exception e) {
                event.getFlowConstruct().getExceptionListener().handleException(e, event);
            }
        }
        this.running.set(false);
    }

    protected boolean isQueuePersistent() {
        return this.queueProfile.isPersistent();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    protected String getQueueName() {
        return String.format("%s(%s)", QUEUE_NAME_PREFIX, this.getStageName());
    }

    protected String getStageName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.next instanceof NamedObject) {
            return ((NamedObject)((Object)this.next)).getName();
        }
        return String.format("%s.%s", this.next.getClass().getName(), this.next.hashCode());
    }

    protected String getStageDescription() {
        return "SEDA Stage " + this.getStageName();
    }

    protected void waitIfPaused() throws InterruptedException {
        if (this.logger.isDebugEnabled() && this.lifecycleManager.isPhaseComplete("pause")) {
            this.logger.debug((Object)(this.getStageDescription() + " is paused. Polling halted until resumed is called"));
        }
        while (this.lifecycleManager.isPhaseComplete("pause") && !this.lifecycleManager.getState().isStopping()) {
            Thread.sleep(50L);
        }
    }

    public void release() {
        this.running.set(false);
    }

    public void initialise() throws InitialisationException {
        this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<SedaStageInterceptingMessageProcessor>(){

            @Override
            public void onTransition(String phaseName, SedaStageInterceptingMessageProcessor object) throws MuleException {
                if (SedaStageInterceptingMessageProcessor.this.next == null) {
                    throw new IllegalStateException("Next message processor cannot be null with this InterceptingMessageProcessor");
                }
                SedaStageInterceptingMessageProcessor.this.queueProfile.configureQueue(SedaStageInterceptingMessageProcessor.this.getQueueName(), SedaStageInterceptingMessageProcessor.this.muleContext.getQueueManager());
                SedaStageInterceptingMessageProcessor.this.queue = SedaStageInterceptingMessageProcessor.this.muleContext.getQueueManager().getQueueSession().getQueue(SedaStageInterceptingMessageProcessor.this.getQueueName());
                if (SedaStageInterceptingMessageProcessor.this.queue == null) {
                    throw new InitialisationException(MessageFactory.createStaticMessage("Queue not created for " + SedaStageInterceptingMessageProcessor.this.getStageDescription()), (Initialisable)SedaStageInterceptingMessageProcessor.this);
                }
            }
        });
    }

    public void start() throws MuleException {
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<SedaStageInterceptingMessageProcessor>(){

            @Override
            public void onTransition(String phaseName, SedaStageInterceptingMessageProcessor object) throws MuleException {
                if (SedaStageInterceptingMessageProcessor.this.queue == null) {
                    throw new IllegalStateException("Not initialised");
                }
                SedaStageInterceptingMessageProcessor.super.start();
                try {
                    SedaStageInterceptingMessageProcessor.this.workManagerSource.getWorkManager().scheduleWork(SedaStageInterceptingMessageProcessor.this, Long.MAX_VALUE, null, new AsyncWorkListener(SedaStageInterceptingMessageProcessor.this.next));
                }
                catch (WorkException e) {
                    throw new LifecycleException(CoreMessages.failedToStart(SedaStageInterceptingMessageProcessor.this.getStageDescription()), e, this);
                }
            }
        });
    }

    public void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<SedaStageInterceptingMessageProcessor>(){

            @Override
            public void onTransition(String phaseName, SedaStageInterceptingMessageProcessor object) throws MuleException {
                try {
                    SedaStageInterceptingMessageProcessor.this.running.whenFalse(null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SedaStageInterceptingMessageProcessor.super.stop();
            }
        });
    }

    public void dispose() {
        this.lifecycleManager.fireDisposePhase(new LifecycleCallback<SedaStageInterceptingMessageProcessor>(){

            @Override
            public void onTransition(String phaseName, SedaStageInterceptingMessageProcessor object) throws MuleException {
                SedaStageInterceptingMessageProcessor.this.queue = null;
            }
        });
    }

    public void pause() throws MuleException {
        this.lifecycleManager.firePausePhase(new EmptyLifecycleCallback<SedaStageInterceptingMessageProcessor>());
    }

    public void resume() throws MuleException {
        this.lifecycleManager.fireResumePhase(new EmptyLifecycleCallback<SedaStageInterceptingMessageProcessor>());
    }

    private class SedaStageWorker
    extends AbstractMuleEventWork {
        public SedaStageWorker(MuleEvent event) {
            super(event);
        }

        protected void doRun() {
            try {
                SedaStageInterceptingMessageProcessor.this.processNextTimed(this.event);
            }
            catch (Exception e) {
                this.event.getSession().setValid(false);
                MessagingExceptionHandler exceptionListener = this.event.getFlowConstruct().getExceptionListener();
                if (e instanceof MessagingException) {
                    exceptionListener.handleException(e, this.event);
                }
                exceptionListener.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(SedaStageInterceptingMessageProcessor.this.getStageDescription()), this.event, (Throwable)e), this.event);
            }
        }
    }
}

