/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import java.lang.reflect.Method;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Callable;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.InvocationResult;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;

public class CallableEntryPointResolver
implements EntryPointResolver {
    protected static final Method callableMethod;

    public InvocationResult invoke(Object component, MuleEventContext context) throws Exception {
        if (component instanceof Callable) {
            Object result = ((Callable)component).onCall(context);
            return new InvocationResult(this, result, callableMethod);
        }
        InvocationResult result = new InvocationResult(this, InvocationResult.State.NOT_SUPPORTED);
        result.setErrorMessage(CoreMessages.objectDoesNotImplementInterface(component, Callable.class).toString());
        return result;
    }

    public String toString() {
        return "CallableEntryPointResolver{}";
    }

    static {
        try {
            callableMethod = Callable.class.getMethod("onCall", MuleEventContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Panic! No onCall(MuleEventContext) method found in the Callable interface."));
        }
    }
}

