/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.util.concurrent.ThreadNameHelper;

public class ProcessingTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(ProcessingTime.class);
    private static volatile Thread referenceThread;
    private static ReferenceQueue<ProcessingTime> queue;
    private static Map refs;
    private AtomicLong accumulator = new AtomicLong();
    private FlowConstructStatistics statistics;
    private String threadName;

    public static ProcessingTime newInstance(MuleSession session, MuleContext muleContext) {
        FlowConstructStatistics stats;
        FlowConstruct fc;
        if (session != null && (fc = session.getFlowConstruct()) != null && (stats = fc.getStatistics()) != null && fc.getStatistics().isEnabled()) {
            return new ProcessingTime(stats, muleContext);
        }
        return null;
    }

    private ProcessingTime(FlowConstructStatistics stats, MuleContext muleContext) {
        this.statistics = stats;
        this.threadName = String.format("%sprocessing.time.monitor", ThreadNameHelper.getPrefix(muleContext));
        if (referenceThread == null) {
            this.startThread();
        }
        refs.put(new Reference(this), refs);
    }

    public void addFlowExecutionBranchTime(long startTime) {
        if (this.statistics.isEnabled()) {
            long elapsedTime = ProcessingTime.getEffectiveTime(System.currentTimeMillis() - startTime);
            this.statistics.addFlowExecutionBranchTime(elapsedTime, this.accumulator.addAndGet(elapsedTime));
        }
    }

    public static long getEffectiveTime(long time) {
        return time <= 0L ? 1L : time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread() {
        Class<ProcessingTime> clazz = ProcessingTime.class;
        synchronized (ProcessingTime.class) {
            if (referenceThread == null) {
                referenceThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block9: {
                            block6: while (true) {
                                while (true) {
                                    if (Thread.currentThread() != referenceThread) {
                                        break block9;
                                    }
                                    try {
                                        java.lang.ref.Reference temp = queue.remove();
                                        Reference ref = (Reference)temp;
                                        refs.remove(ref);
                                        FlowConstructStatistics stats = ref.getStatistics();
                                        if (!stats.isEnabled()) continue block6;
                                        stats.addCompleteFlowExecutionTime(ref.getAccumulator().longValue());
                                        continue;
                                    }
                                    catch (InterruptedException ex) {
                                        Thread.currentThread().interrupt();
                                        break block9;
                                    }
                                    catch (Exception ex) {
                                        logger.error((Object)this, (Throwable)ex);
                                        continue;
                                    }
                                    break;
                                }
                                break;
                            }
                            finally {
                                referenceThread = null;
                            }
                        }
                    }
                }, this.threadName);
                referenceThread.setDaemon(true);
                referenceThread.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void stopTimer() {
        if (referenceThread != null) {
            referenceThread.interrupt();
            referenceThread = null;
        }
        refs.clear();
    }

    static {
        queue = new ReferenceQueue();
        refs = new ConcurrentHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Reference
    extends WeakReference<ProcessingTime> {
        private FlowConstructStatistics statistics;
        private AtomicLong accumulator;

        Reference(ProcessingTime time) {
            super(time, queue);
            this.statistics = time.statistics;
            this.accumulator = time.accumulator;
        }

        public AtomicLong getAccumulator() {
            return this.accumulator;
        }

        public FlowConstructStatistics getStatistics() {
            return this.statistics;
        }
    }
}

