/*
 * Decompiled with CFR 0.152.
 */
package org.mule.client;

import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointCache;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.transport.ReceiveException;
import org.mule.endpoint.SimpleEndpointCache;
import org.mule.exception.DefaultServiceExceptionStrategy;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.session.DefaultMuleSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocalMuleClient
implements LocalMuleClient {
    protected final MuleContext muleContext;
    private final EndpointCache endpointCache;

    public DefaultLocalMuleClient(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.endpointCache = new SimpleEndpointCache(muleContext);
    }

    @Override
    public MuleMessage process(OutboundEndpoint endpoint, Object payload, Map<String, Object> messageProperties) throws MuleException {
        return this.process(endpoint, new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    @Override
    public MuleMessage process(OutboundEndpoint endpoint, MuleMessage message) throws MuleException {
        return this.returnMessage(endpoint.process(this.createMuleEvent(message, endpoint)));
    }

    @Override
    public MuleMessage request(InboundEndpoint endpoint, long timeout) throws MuleException {
        try {
            return endpoint.request(timeout);
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    @Override
    public void dispatch(String url, Object payload, Map<String, Object> messageProperties) throws MuleException {
        this.dispatch(url, new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    @Override
    public MuleMessage send(String url, Object payload, Map<String, Object> messageProperties) throws MuleException {
        return this.send(url, new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    @Override
    public MuleMessage send(String url, MuleMessage message) throws MuleException {
        OutboundEndpoint endpoint = this.endpointCache.getOutboundEndpoint(url, MessageExchangePattern.REQUEST_RESPONSE, null);
        return this.returnMessage(endpoint.process(this.createMuleEvent(message, endpoint)));
    }

    @Override
    public MuleMessage send(String url, Object payload, Map<String, Object> messageProperties, long timeout) throws MuleException {
        return this.send(url, new DefaultMuleMessage(payload, messageProperties, this.muleContext), timeout);
    }

    @Override
    public MuleMessage send(String url, MuleMessage message, long timeout) throws MuleException {
        OutboundEndpoint endpoint = this.endpointCache.getOutboundEndpoint(url, MessageExchangePattern.REQUEST_RESPONSE, timeout);
        return this.returnMessage(endpoint.process(this.createMuleEvent(message, endpoint)));
    }

    @Override
    public void dispatch(String url, MuleMessage message) throws MuleException {
        OutboundEndpoint endpoint = this.endpointCache.getOutboundEndpoint(url, MessageExchangePattern.ONE_WAY, null);
        endpoint.process(this.createMuleEvent(message, endpoint));
    }

    @Override
    public MuleMessage request(String url, long timeout) throws MuleException {
        InboundEndpoint endpoint = this.endpointCache.getInboundEndpoint(url, MessageExchangePattern.ONE_WAY);
        try {
            return endpoint.request(timeout);
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    @Override
    public MuleMessage process(String uri, MessageExchangePattern mep, Object payload, Map<String, Object> messageProperties) throws MuleException {
        return this.process(uri, mep, new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    @Override
    public MuleMessage process(String uri, MessageExchangePattern mep, MuleMessage message) throws MuleException {
        OutboundEndpoint endpoint = this.endpointCache.getOutboundEndpoint(uri, mep, null);
        return this.returnMessage(endpoint.process(this.createMuleEvent(message, endpoint)));
    }

    protected MuleEvent createMuleEvent(MuleMessage message, OutboundEndpoint endpoint) {
        DefaultMuleSession session = new DefaultMuleSession(new MuleClientFlowConstruct(this.muleContext), this.muleContext);
        return new DefaultMuleEvent(message, endpoint, session);
    }

    protected MuleMessage returnMessage(MuleEvent event) {
        if (event != null) {
            return event.getMessage();
        }
        return null;
    }

    public static class MuleClientFlowConstruct
    implements FlowConstruct {
        MuleContext muleContext;

        public MuleClientFlowConstruct(MuleContext muleContext) {
            this.muleContext = muleContext;
        }

        public String getName() {
            return "MuleClient";
        }

        public MessagingExceptionHandler getExceptionListener() {
            return new DefaultServiceExceptionStrategy(this.muleContext);
        }

        public LifecycleState getLifecycleState() {
            return null;
        }

        public FlowConstructStatistics getStatistics() {
            return null;
        }

        public MuleContext getMuleContext() {
            return this.muleContext;
        }

        public MessageInfoMapping getMessageInfoMapping() {
            return null;
        }

        public MessageProcessorChain getMessageProcessorChain() {
            return null;
        }
    }
}

