/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zarinpal.libs.views.R;
import com.zarinpal.libs.views.ZarinImageView;
import com.zarinpal.libs.views.ZarinTextView;
import com.zarinpal.libs.views.utitlity.FontUtility;

public class ZarinItemView
extends LinearLayout {
    private ZarinImageView imgIconRight;
    private ZarinImageView imgIconLeft;
    private ZarinTextView txtTitle;
    private LinearLayout layoutIconRight;
    private CardView cardView;
    private View.OnClickListener listener;
    private Integer iconRightPadding;
    private Integer iconLeftPadding;
    private Integer iconRight;
    private Integer iconLeft;
    private String title;
    private boolean hasActive;
    private float textSize;
    private int bgIconRight;
    private int fontFace;
    private int bgColor;
    private int textColor;
    private int iconRightTint;
    private int iconLeftTint;
    private int rotateLeftIcon;
    private int rotateRightIcon;
    private int disableColor;
    private int color;

    public ZarinItemView(Context context) {
        super(context);
    }

    public ZarinItemView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initializeView(context, attrs);
    }

    public ZarinItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeView(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeView(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ZarinItemView);
        try {
            this.bgIconRight = typedArray.getInteger(R.styleable.ZarinItemView_zp_bgIconRight, 0);
            this.fontFace = typedArray.getInt(R.styleable.ZarinItemView_zp_fontFace, 2);
            this.iconLeft = typedArray.getResourceId(R.styleable.ZarinItemView_zp_iconLeft, 0);
            this.iconRight = typedArray.getResourceId(R.styleable.ZarinItemView_zp_iconRight, 0);
            this.textSize = typedArray.getDimensionPixelSize(R.styleable.ZarinItemView_zp_titleSize, 12);
            this.title = typedArray.getString(R.styleable.ZarinItemView_zp_setTitle);
            this.iconRightPadding = typedArray.getDimensionPixelSize(R.styleable.ZarinItemView_zp_paddingIconRight, 5);
            this.iconLeftPadding = typedArray.getDimensionPixelSize(R.styleable.ZarinItemView_zp_paddingIconLeft, 5);
            this.bgColor = typedArray.getColor(R.styleable.ZarinItemView_zp_bgColor, -1);
            this.textColor = typedArray.getColor(R.styleable.ZarinItemView_android_textColor, -16777216);
            this.iconLeftTint = typedArray.getColor(R.styleable.ZarinItemView_zp_tintLeftColor, 0);
            this.iconRightTint = typedArray.getColor(R.styleable.ZarinItemView_zp_tintRightColor, 0);
            this.hasActive = typedArray.getBoolean(R.styleable.ZarinItemView_zp_hasActive, true);
            this.rotateLeftIcon = typedArray.getInt(R.styleable.ZarinItemView_zp_rotateLeftIcon, 0);
            this.rotateRightIcon = typedArray.getInt(R.styleable.ZarinItemView_zp_rotateRightIcon, 0);
            this.disableColor = typedArray.getColor(R.styleable.ZarinItemView_zp_disableColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.disable_color));
        }
        finally {
            typedArray.recycle();
        }
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.zarin_item_view, (ViewGroup)this, true);
        this.cardView = (CardView)view.findViewById(R.id.card_view);
        this.layoutIconRight = (LinearLayout)view.findViewById(R.id.layout_icon_right);
        this.imgIconLeft = (ZarinImageView)view.findViewById(R.id.img_icon_left);
        this.imgIconRight = (ZarinImageView)view.findViewById(R.id.img_icon_right);
        this.txtTitle = (ZarinTextView)view.findViewById(R.id.txt_title);
        this.cardView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ZarinItemView.this.listener != null) {
                    ZarinItemView.this.listener.onClick(view);
                }
            }
        });
        this.setEnabled(this.hasActive);
        this.updateView();
    }

    public void setIconRight(@DrawableRes int value) {
        if (this.imgIconRight == null) {
            return;
        }
        if (value == 0) {
            return;
        }
        this.imgIconRight.setImageResource(value);
    }

    public void setIconLeft(@DrawableRes int value) {
        if (this.imgIconLeft == null) {
            return;
        }
        if (value == 0) {
            return;
        }
        this.imgIconLeft.setImageResource(value);
    }

    public void setIconBg(int value) {
        if (this.layoutIconRight == null) {
            return;
        }
        if (value == 0) {
            return;
        }
        this.layoutIconRight.setBackgroundResource(value);
    }

    public void setIconBg(ShapeDrawable shapeDrawable) {
        if (this.layoutIconRight == null) {
            return;
        }
        if (shapeDrawable == null) {
            return;
        }
        this.layoutIconRight.setBackground((Drawable)shapeDrawable);
    }

    public void setTitle(String value) {
        if (this.txtTitle == null) {
            return;
        }
        this.txtTitle.setText(value);
    }

    public void setTextSize(float value) {
        if (this.txtTitle == null) {
            return;
        }
        this.txtTitle.setTextSize(value);
    }

    public void setOnClickListener(View.OnClickListener listener) {
        if (listener == null) {
            return;
        }
        this.listener = listener;
    }

    public ZarinImageView getImageViewRight() {
        return this.imgIconRight;
    }

    public ZarinImageView getImageViewLeft() {
        return this.imgIconLeft;
    }

    public ViewGroup getLayoutIconRight() {
        return this.layoutIconRight;
    }

    public void setTintRightIcon(@ColorInt int color2) {
        if (this.imgIconRight == null) {
            return;
        }
        this.imgIconRight.setTintColor(color2);
    }

    public void setTintLeftIcon(@ColorInt int color2) {
        if (this.imgIconLeft == null) {
            return;
        }
        this.imgIconLeft.setTintColor(color2);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cardView.setEnabled(enabled);
        if (!enabled) {
            this.setViewDisableColor();
        }
    }

    private void setViewDisableColor() {
        this.layoutIconRight.setBackground(null);
        this.imgIconRight.setTintColor(this.disableColor);
        this.imgIconLeft.setTintColor(this.disableColor);
        this.txtTitle.setTextColor(this.disableColor);
    }

    private void updateView() {
        this.cardView.setCardBackgroundColor(this.bgColor);
        this.imgIconRight.setPadding(this.iconRightPadding, this.iconRightPadding, this.iconRightPadding, this.iconRightPadding);
        this.imgIconLeft.setPadding(this.iconLeftPadding, this.iconLeftPadding, this.iconLeftPadding, this.iconLeftPadding);
        this.txtTitle.setTextColor(this.textColor);
        this.imgIconLeft.setTintColor(this.iconLeftTint);
        this.imgIconRight.setTintColor(this.iconRightTint);
        this.imgIconRight.setRotation(this.rotateRightIcon);
        this.imgIconLeft.setRotation(this.rotateLeftIcon);
        this.setIconBg(this.bgIconRight);
        this.setIconLeft(this.iconLeft);
        this.setIconRight(this.iconRight);
        this.setTitle(this.title);
        this.setTextSize(this.textSize);
        this.setFontFace();
        if (!this.cardView.isEnabled() || !this.hasActive) {
            this.setViewDisableColor();
        }
    }

    private void setFontFace() {
        String fontFamily = "sansLight.ttf";
        switch (this.fontFace) {
            case 1: {
                fontFamily = "sansULight.ttf";
                break;
            }
            case 2: {
                fontFamily = "sansBold.ttf";
                break;
            }
            case 3: {
                fontFamily = "ocra.ttf";
            }
        }
        this.txtTitle.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
    }

    public void setAnimationColorsItem(final int[] colors) {
        final ShapeDrawable oval = new ShapeDrawable((Shape)new OvalShape());
        oval.setIntrinsicHeight(200);
        oval.setIntrinsicWidth(200);
        oval.setAlpha(30);
        this.color = this.imgIconRight.getTintColor() == 0 ? colors[0] : colors[1];
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ValueAnimator valueAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{ZarinItemView.this.color, colors[0]});
                valueAnimator.setDuration(500L);
                valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        int color2 = (Integer)valueAnimator.getAnimatedValue();
                        if (!ZarinItemView.this.cardView.isEnabled()) {
                            ZarinItemView.this.setViewDisableColor();
                            return;
                        }
                        oval.getPaint().setColor(color2);
                        ZarinItemView.this.setIconBg(oval);
                        ZarinItemView.this.imgIconRight.setTintColor(color2);
                        ZarinItemView.this.txtTitle.setTextColor(ZarinItemView.this.textColor);
                    }
                });
                valueAnimator.start();
            }
        }, 250L);
    }
}

