/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.text.TextUtilsCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import android.view.inputmethod.InputMethodManager;
import com.zarinpal.libs.views.R;
import com.zarinpal.libs.views.utitlity.FontUtility;
import java.util.Locale;

public class ZarinPinView
extends AppCompatEditText {
    private static final String XML_NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    protected String mMask = null;
    protected StringBuilder mMaskChars = null;
    protected String mSingleCharHint = null;
    protected int mAnimatedType = 0;
    protected float mSpace = 24.0f;
    protected float mCharSize;
    protected float mNumChars = 4.0f;
    protected float mTextBottomPadding = 8.0f;
    protected int mMaxLength = 4;
    protected RectF[] mLineCoords;
    protected float[] mCharBottom;
    protected Paint mCharPaint;
    protected Paint mLastCharPaint;
    protected Paint mSingleCharPaint;
    protected Drawable mPinBackground;
    protected Rect mTextHeight = new Rect();
    protected boolean mIsDigitSquare = false;
    protected View.OnClickListener mClickListener;
    protected OnPinEnteredListener mOnPinEnteredListener = null;
    protected float mLineStroke = 1.0f;
    protected float mLineStrokeSelected = 2.0f;
    protected Paint mLinesPaint;
    protected boolean mAnimate = false;
    protected boolean mHasError = false;
    protected ColorStateList mOriginalTextColors;
    private int fontFace;
    private int activeColor;
    protected int[][] mStates = new int[][]{{0x10100A1}, {16842914}, {16842908}, {-16842908}};
    protected int[] mColors = new int[]{-16711936, -65536, -16777216, -7829368};
    protected ColorStateList mColorStates = new ColorStateList(this.mStates, this.mColors);

    public ZarinPinView(Context context) {
        super(context);
    }

    public ZarinPinView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ZarinPinView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
        this.mNumChars = maxLength;
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        this.setText(null);
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        int colorUnfocused;
        int colorFocused;
        int colorSelected;
        TypedValue outValue;
        float multi = context.getResources().getDisplayMetrics().density;
        this.mLineStroke = multi * this.mLineStroke;
        this.mLineStrokeSelected = multi * this.mLineStrokeSelected;
        this.mSpace = multi * this.mSpace;
        this.mTextBottomPadding = multi * this.mTextBottomPadding;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ZarinPinView, 0, 0);
        try {
            outValue = new TypedValue();
            ta.getValue(R.styleable.ZarinPinView_zp_pinAnimationType, outValue);
            this.mAnimatedType = outValue.data;
            this.mMask = ta.getString(R.styleable.ZarinPinView_zp_pinCharacterMask);
            this.fontFace = ta.getInt(R.styleable.ZarinPinView_zp_fontFace, 0);
            this.mSingleCharHint = ta.getString(R.styleable.ZarinPinView_zp_pinRepeatedHint);
            this.mLineStroke = ta.getDimension(R.styleable.ZarinPinView_zp_pinLineStroke, this.mLineStroke);
            this.mLineStrokeSelected = ta.getDimension(R.styleable.ZarinPinView_zp_pinLineStrokeSelected, this.mLineStrokeSelected);
            this.mSpace = ta.getDimension(R.styleable.ZarinPinView_zp_pinCharacterSpacing, this.mSpace);
            this.mTextBottomPadding = ta.getDimension(R.styleable.ZarinPinView_zp_pinTextBottomPadding, this.mTextBottomPadding);
            this.mIsDigitSquare = ta.getBoolean(R.styleable.ZarinPinView_zp_pinBackgroundIsSquare, this.mIsDigitSquare);
            this.mPinBackground = ta.getDrawable(R.styleable.ZarinPinView_zp_pinBackgroundDrawable);
            ColorStateList colors = ta.getColorStateList(R.styleable.ZarinPinView_zp_pinLineColors);
            this.activeColor = ta.getColor(R.styleable.ZarinPinView_zp_activeColor, -7829368);
            if (colors != null) {
                this.mColorStates = colors;
            }
        }
        finally {
            ta.recycle();
        }
        this.setFontFace();
        this.mCharPaint = new Paint((Paint)this.getPaint());
        this.mLastCharPaint = new Paint((Paint)this.getPaint());
        this.mSingleCharPaint = new Paint((Paint)this.getPaint());
        this.mLinesPaint = new Paint((Paint)this.getPaint());
        this.mLinesPaint.setStrokeWidth(this.mLineStroke);
        outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorControlActivated, outValue, true);
        this.mColors[0] = colorSelected = outValue.data;
        this.mColors[1] = colorFocused = this.isInEditMode() ? -7829368 : ContextCompat.getColor((Context)context, (int)R.color.pin_normal);
        this.mColors[2] = colorUnfocused = this.isInEditMode() ? -7829368 : ContextCompat.getColor((Context)context, (int)R.color.pin_normal);
        this.setBackgroundResource(0);
        this.mMaxLength = attrs.getAttributeIntValue(XML_NAMESPACE_ANDROID, "maxLength", 4);
        this.mNumChars = this.mMaxLength;
        super.setCustomSelectionActionModeCallback(new ActionMode.Callback(){

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                return false;
            }

            public void onDestroyActionMode(ActionMode mode) {
            }

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                return false;
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                return false;
            }
        });
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ZarinPinView.this.setSelection(ZarinPinView.this.getText().length());
                if (ZarinPinView.this.mClickListener != null) {
                    ZarinPinView.this.mClickListener.onClick(v);
                }
            }
        });
        super.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ZarinPinView.this.setSelection(ZarinPinView.this.getText().length());
                return true;
            }
        });
        if ((this.getInputType() & 0x80) == 128 && TextUtils.isEmpty((CharSequence)this.mMask)) {
            this.mMask = "\u25cf";
        } else if ((this.getInputType() & 0x10) == 16 && TextUtils.isEmpty((CharSequence)this.mMask)) {
            this.mMask = "\u25cf";
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMask)) {
            this.mMaskChars = this.getMaskChars();
        }
        this.getPaint().getTextBounds("|", 0, 1, this.mTextHeight);
        this.mAnimate = this.mAnimatedType > -1;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int startX;
        int rtlFlag;
        boolean isLayoutRtl;
        super.onSizeChanged(w, h, oldw, oldh);
        this.mOriginalTextColors = this.getTextColors();
        if (this.mOriginalTextColors != null) {
            this.mLastCharPaint.setColor(this.mOriginalTextColors.getDefaultColor());
            this.mCharPaint.setColor(this.mOriginalTextColors.getDefaultColor());
            this.mSingleCharPaint.setColor(this.getCurrentHintTextColor());
        }
        int availableWidth = this.getWidth() - ViewCompat.getPaddingEnd((View)this) - ViewCompat.getPaddingStart((View)this);
        this.mCharSize = this.mSpace < 0.0f ? (float)availableWidth / (this.mNumChars * 2.0f - 1.0f) : ((float)availableWidth - this.mSpace * (this.mNumChars - 1.0f)) / this.mNumChars;
        this.mLineCoords = new RectF[(int)this.mNumChars];
        this.mCharBottom = new float[(int)this.mNumChars];
        int bottom = this.getHeight() - this.getPaddingBottom();
        boolean bl = isLayoutRtl = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
        if (isLayoutRtl) {
            rtlFlag = -1;
            startX = (int)((float)(this.getWidth() - ViewCompat.getPaddingStart((View)this)) - this.mCharSize);
        } else {
            rtlFlag = 1;
            startX = ViewCompat.getPaddingStart((View)this);
        }
        int i = 0;
        while ((float)i < this.mNumChars) {
            this.mLineCoords[i] = new RectF((float)startX, (float)bottom, (float)startX + this.mCharSize, (float)bottom);
            if (this.mPinBackground != null) {
                if (this.mIsDigitSquare) {
                    this.mLineCoords[i].top = this.getPaddingTop();
                    this.mLineCoords[i].right = (float)startX + this.mLineCoords[i].height();
                } else {
                    this.mLineCoords[i].top -= (float)this.mTextHeight.height() + this.mTextBottomPadding * 2.0f;
                }
            }
            startX = this.mSpace < 0.0f ? (int)((float)startX + (float)rtlFlag * this.mCharSize * 2.0f) : (int)((float)startX + (float)rtlFlag * (this.mCharSize + this.mSpace));
            this.mCharBottom[i] = this.mLineCoords[i].bottom - this.mTextBottomPadding;
            ++i;
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mClickListener = l;
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback actionModeCallback) {
        throw new RuntimeException("setCustomSelectionActionModeCallback() not supported.");
    }

    protected void onDraw(Canvas canvas) {
        CharSequence text = this.getFullText();
        int textLength = text.length();
        float[] textWidths = new float[textLength];
        this.getPaint().getTextWidths(text, 0, textLength, textWidths);
        float hintWidth = 0.0f;
        if (this.mSingleCharHint != null) {
            float[] hintWidths = new float[this.mSingleCharHint.length()];
            this.getPaint().getTextWidths(this.mSingleCharHint, hintWidths);
            for (float i : hintWidths) {
                hintWidth += i;
            }
        }
        int i = 0;
        while ((float)i < this.mNumChars) {
            if (this.mPinBackground != null) {
                this.updateDrawableState(i < textLength, i == textLength);
                this.mPinBackground.setBounds((int)this.mLineCoords[i].left, (int)this.mLineCoords[i].top, (int)this.mLineCoords[i].right, (int)this.mLineCoords[i].bottom);
                this.mPinBackground.draw(canvas);
            }
            float middle = this.mLineCoords[i].left + this.mCharSize / 2.0f;
            if (textLength > i) {
                if (!this.mAnimate || i != textLength - 1) {
                    canvas.drawText(text, i, i + 1, middle - textWidths[i] / 2.0f, this.mCharBottom[i], this.mCharPaint);
                } else {
                    canvas.drawText(text, i, i + 1, middle - textWidths[i] / 2.0f, this.mCharBottom[i], this.mLastCharPaint);
                }
            } else if (this.mSingleCharHint != null) {
                canvas.drawText(this.mSingleCharHint, middle - hintWidth / 2.0f, this.mCharBottom[i], this.mSingleCharPaint);
            }
            if (this.mPinBackground == null) {
                this.updateColorForLines(i <= textLength);
                canvas.drawLine(this.mLineCoords[i].left, this.mLineCoords[i].top, this.mLineCoords[i].right, this.mLineCoords[i].bottom, this.mLinesPaint);
            }
            ++i;
        }
    }

    private CharSequence getFullText() {
        if (this.mMask == null) {
            return this.getText();
        }
        return this.getMaskChars();
    }

    private StringBuilder getMaskChars() {
        if (this.mMaskChars == null) {
            this.mMaskChars = new StringBuilder();
        }
        int textLength = this.getText().length();
        while (this.mMaskChars.length() != textLength) {
            if (this.mMaskChars.length() < textLength) {
                this.mMaskChars.append(this.mMask);
                continue;
            }
            this.mMaskChars.deleteCharAt(this.mMaskChars.length() - 1);
        }
        return this.mMaskChars;
    }

    private int getColorForState(int ... states) {
        return this.mColorStates.getColorForState(states, -7829368);
    }

    protected void updateColorForLines(boolean hasTextOrIsNext) {
        if (this.mHasError) {
            this.mLinesPaint.setColor(this.getColorForState(16842914));
        } else if (this.isFocused()) {
            this.mLinesPaint.setStrokeWidth(this.mLineStrokeSelected);
            this.mLinesPaint.setColor(this.getColorForState(16842908));
            if (hasTextOrIsNext) {
                this.mLinesPaint.setColor(this.getColorForState(0x10100A1));
                this.mLinesPaint.setColor(this.activeColor);
            }
        } else {
            this.mLinesPaint.setStrokeWidth(this.mLineStroke);
            this.mLinesPaint.setColor(this.getColorForState(-16842908));
        }
    }

    protected void updateDrawableState(boolean hasText, boolean isNext) {
        if (this.mHasError) {
            this.mPinBackground.setState(new int[]{16842914});
        } else if (this.isFocused()) {
            this.mPinBackground.setState(new int[]{16842908});
            if (isNext) {
                this.mPinBackground.setState(new int[]{16842908, 0x10100A1});
            } else if (hasText) {
                this.mPinBackground.setState(new int[]{16842908, 0x10100A0});
            }
        } else {
            this.mPinBackground.setState(new int[]{-16842908});
        }
    }

    public void setError(boolean hasError) {
        this.mHasError = hasError;
    }

    public boolean isError() {
        return this.mHasError;
    }

    public void focus() {
        this.requestFocus();
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.showSoftInput((View)this, 0);
        }
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        this.setError(false);
        if (this.mLineCoords == null || !this.mAnimate) {
            if (this.mOnPinEnteredListener != null && text.length() == this.mMaxLength) {
                this.mOnPinEnteredListener.onPinEntered(text);
            }
            return;
        }
        if (this.mAnimatedType == -1) {
            this.invalidate();
            return;
        }
        if (lengthAfter > lengthBefore) {
            if (this.mAnimatedType == 0) {
                this.animatePopIn();
            } else {
                this.animateBottomUp(text, start);
            }
        }
    }

    private void animatePopIn() {
        ValueAnimator va = ValueAnimator.ofFloat((float[])new float[]{1.0f, this.getPaint().getTextSize()});
        va.setDuration(200L);
        va.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ZarinPinView.this.mLastCharPaint.setTextSize(((Float)animation.getAnimatedValue()).floatValue());
                ZarinPinView.this.invalidate();
            }
        });
        if (this.getText().length() == this.mMaxLength && this.mOnPinEnteredListener != null) {
            va.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    ZarinPinView.this.mOnPinEnteredListener.onPinEntered((CharSequence)ZarinPinView.this.getText());
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
        va.start();
    }

    private void animateBottomUp(CharSequence text, final int start) {
        this.mCharBottom[start] = this.mLineCoords[start].bottom - this.mTextBottomPadding;
        ValueAnimator animUp = ValueAnimator.ofFloat((float[])new float[]{this.mCharBottom[start] + this.getPaint().getTextSize(), this.mCharBottom[start]});
        animUp.setDuration(300L);
        animUp.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        animUp.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Float value = (Float)animation.getAnimatedValue();
                ZarinPinView.this.mCharBottom[start] = value.floatValue();
                ZarinPinView.this.invalidate();
            }
        });
        this.mLastCharPaint.setAlpha(255);
        ValueAnimator animAlpha = ValueAnimator.ofInt((int[])new int[]{0, 255});
        animAlpha.setDuration(300L);
        animAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Integer value = (Integer)animation.getAnimatedValue();
                ZarinPinView.this.mLastCharPaint.setAlpha(value.intValue());
            }
        });
        AnimatorSet set = new AnimatorSet();
        if (text.length() == this.mMaxLength && this.mOnPinEnteredListener != null) {
            set.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    ZarinPinView.this.mOnPinEnteredListener.onPinEntered((CharSequence)ZarinPinView.this.getText());
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
        set.playTogether(new Animator[]{animUp, animAlpha});
        set.start();
    }

    private void setFontFace() {
        String fontFamily = "sansLight.ttf";
        switch (this.fontFace) {
            case 1: {
                fontFamily = "sansULight.ttf";
                break;
            }
            case 2: {
                fontFamily = "sansBold.ttf";
                break;
            }
            case 3: {
                fontFamily = "ocra.ttf";
            }
        }
        this.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
    }

    public void setAnimateText(boolean animate) {
        this.mAnimate = animate;
    }

    public void setOnPinEnteredListener(OnPinEnteredListener l) {
        this.mOnPinEnteredListener = l;
    }

    public static interface OnPinEnteredListener {
        public void onPinEntered(CharSequence var1);
    }
}

