/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.zarinpal.libs.views.R;

public class ZarinTimer
extends LinearLayout {
    public static final String TAG = ZarinTimer.class.getSimpleName();
    private OnTimeCompleteListener timeCompleteListener;
    private ProgressBar progressView;
    private int time;
    private int counter;
    private Drawable drawable;
    int millTime = 0;

    public ZarinTimer(Context context) {
        super(context);
    }

    public ZarinTimer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ZarinTimer);
        this.time = typedArray.getInteger(R.styleable.ZarinTimer_zp_time, 5);
        this.drawable = typedArray.getDrawable(R.styleable.ZarinTimer_zp_background);
        typedArray.recycle();
        if (this.drawable == null) {
            this.drawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.yellow_progress_bar);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initializeView();
    }

    private void initializeView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.progress_view_horizontal, (ViewGroup)this, true);
        this.progressView = (ProgressBar)view.findViewById(R.id.custom_progress_view);
        this.progressView.setProgressDrawable(this.drawable);
    }

    public void setTime(int timeSec) {
        this.time = timeSec;
    }

    public void setOnTimeCompleteListener(OnTimeCompleteListener listener) {
        this.timeCompleteListener = listener;
    }

    public void startTimer(final OnTimerListener listener) {
        if (this.progressView == null) {
            return;
        }
        this.millTime = this.time * 1000;
        this.progressView.setMax(this.millTime);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (ZarinTimer.this.counter <= ZarinTimer.this.millTime) {
                        ZarinTimer.this.progressView.post(new Runnable(){

                            @Override
                            public void run() {
                                ZarinTimer.this.progressView.setProgress(ZarinTimer.this.counter);
                                if (listener != null) {
                                    ZarinTimer.this.counter = ZarinTimer.this.counter + 100;
                                    ZarinTimer.this.time = ZarinTimer.this.time - 100;
                                    listener.onTime(ZarinTimer.this.formatsMilliSeconds(ZarinTimer.this.time * -1));
                                }
                            }
                        });
                        Thread.sleep(100L);
                    }
                    if (ZarinTimer.this.timeCompleteListener != null) {
                        ZarinTimer.this.timeCompleteListener.onTimeComplete();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    private String formatsMilliSeconds(long milliseconds) {
        String finalTimerString = "";
        int hours = (int)(milliseconds / 3600000L);
        int minutes = (int)(milliseconds % 3600000L) / 60000;
        int seconds = (int)(milliseconds % 3600000L % 60000L / 1000L);
        if (hours > 0) {
            finalTimerString = hours + ":";
        }
        String secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
        finalTimerString = finalTimerString + minutes + " : " + secondsString;
        return finalTimerString;
    }

    public static interface OnTimeCompleteListener {
        public void onTimeComplete();
    }

    public static interface OnTimerListener {
        public void onTime(String var1);
    }
}

