/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views.utitlity;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;
import com.zarinpal.libs.views.R;

public class DrawableResource {
    private Context context;

    public DrawableResource(Context context) {
        this.context = context;
    }

    public void getIssuerBankLogo(String slug, final OnFetchIssuerBankLogoListener listener) {
        if (slug.equals("ZarinCard")) {
            Bitmap bmp = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.zarin_tiny);
            listener.onBitmap(bmp);
            return;
        }
        int drawableResource = this.context.getResources().getIdentifier(slug.toLowerCase(), "drawable", this.context.getPackageName());
        if (drawableResource != 0) {
            Bitmap bmp = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)drawableResource);
            listener.onBitmap(bmp);
            return;
        }
        Picasso.with((Context)this.context).load(this.getIssuerBankLogo(slug)).into(new Target(){

            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                listener.onBitmap(bitmap);
            }

            public void onBitmapFailed(Drawable errorDrawable) {
            }

            public void onPrepareLoad(Drawable placeHolderDrawable) {
            }
        });
    }

    private String getIssuerBankLogo(String slug) {
        return String.format("https://cdn.zarinpal.com/logos/banks/80x80/%s.png", slug);
    }

    public static interface OnFetchIssuerBankLogoListener {
        public void onBitmap(Bitmap var1);
    }
}

