/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zarinpal.libs.views.R;
import com.zarinpal.libs.views.ZarinImageView;
import com.zarinpal.libs.views.ZarinTextView;
import com.zarinpal.libs.views.utitlity.FontUtility;

public class ZarinItemView
extends LinearLayout
implements View.OnClickListener {
    private ZarinImageView imgIconRight;
    private ZarinImageView imgIconLeft;
    private ZarinTextView txtTitle;
    private LinearLayout layoutIconRight;
    private CardView cardView;
    private OnClickItemListener listener;
    private int bgIconRight;
    private int fontFace;
    private Integer iconRight;
    private Integer iconLeft;
    private float textSize;
    private String title;
    private Integer iconRightPadding;
    private Integer iconLeftPadding;
    private int bgColor;
    private int textColor;
    private int iconRightTint;
    private int iconLeftTint;
    private boolean hasActive;

    public ZarinItemView(Context context) {
        super(context);
    }

    public ZarinItemView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initializeView(context, attrs);
    }

    public ZarinItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeView(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeView(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ZarinItemView);
        try {
            this.bgIconRight = typedArray.getInteger(R.styleable.ZarinItemView_zp_bgIconRight, 0);
            this.fontFace = typedArray.getInt(R.styleable.ZarinItemView_zp_fontFace, 2);
            this.iconLeft = typedArray.getResourceId(R.styleable.ZarinItemView_zp_iconLeft, 0);
            this.iconRight = typedArray.getResourceId(R.styleable.ZarinItemView_zp_iconRight, 0);
            this.textSize = typedArray.getDimensionPixelSize(R.styleable.ZarinItemView_zp_titleSize, 12);
            this.title = typedArray.getString(R.styleable.ZarinItemView_zp_setTitle);
            this.iconRightPadding = typedArray.getDimensionPixelSize(R.styleable.ZarinItemView_zp_paddingIconRight, 5);
            this.iconLeftPadding = typedArray.getDimensionPixelSize(R.styleable.ZarinItemView_zp_paddingIconLeft, 5);
            this.bgColor = typedArray.getColor(R.styleable.ZarinItemView_zp_bgColor, -1);
            this.textColor = typedArray.getColor(R.styleable.ZarinItemView_android_textColor, -16777216);
            this.iconLeftTint = typedArray.getColor(R.styleable.ZarinItemView_zp_tintLeftColor, 0);
            this.iconRightTint = typedArray.getColor(R.styleable.ZarinItemView_zp_tintRightColor, 0);
            this.hasActive = typedArray.getBoolean(R.styleable.ZarinItemView_zp_hasActive, true);
        }
        finally {
            typedArray.recycle();
        }
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.zarin_item_view, (ViewGroup)this, true);
        this.cardView = (CardView)view.findViewById(R.id.card_view);
        this.layoutIconRight = (LinearLayout)view.findViewById(R.id.layout_icon_right);
        this.imgIconLeft = (ZarinImageView)view.findViewById(R.id.img_icon_left);
        this.imgIconRight = (ZarinImageView)view.findViewById(R.id.img_icon_right);
        this.txtTitle = (ZarinTextView)view.findViewById(R.id.txt_title);
        this.cardView.setCardBackgroundColor(this.bgColor);
        this.imgIconRight.setPadding(this.iconRightPadding, this.iconRightPadding, this.iconRightPadding, this.iconRightPadding);
        this.imgIconLeft.setPadding(this.iconLeftPadding, this.iconLeftPadding, this.iconLeftPadding, this.iconLeftPadding);
        this.txtTitle.setTextColor(this.textColor);
        this.imgIconLeft.setTintColor(this.iconLeftTint);
        this.imgIconRight.setTintColor(this.iconRightTint);
        this.setIconBg(this.bgIconRight);
        this.setIconLeft(this.iconLeft);
        this.setIconRight(this.iconRight);
        this.setTitle(this.title);
        this.setTextSize(this.textSize);
        this.setFontFace();
        this.setEnabled(this.hasActive);
        this.cardView.setOnClickListener((View.OnClickListener)this);
    }

    public void setIconRight(@DrawableRes int value) {
        if (this.imgIconRight == null) {
            return;
        }
        if (value == 0) {
            return;
        }
        this.imgIconRight.setImageResource(value);
    }

    public void setIconLeft(@DrawableRes int value) {
        if (this.imgIconLeft == null) {
            return;
        }
        if (value == 0) {
            return;
        }
        this.imgIconLeft.setImageResource(value);
    }

    public void setIconBg(int value) {
        if (this.layoutIconRight == null) {
            return;
        }
        if (value == 0) {
            return;
        }
        this.layoutIconRight.setBackgroundResource(value);
    }

    public void setIconBg(ShapeDrawable shapeDrawable) {
        if (this.layoutIconRight == null) {
            return;
        }
        if (shapeDrawable == null) {
            return;
        }
        this.layoutIconRight.setBackground((Drawable)shapeDrawable);
    }

    public void setTitle(String value) {
        if (this.txtTitle == null) {
            return;
        }
        this.txtTitle.setText(value);
    }

    public void setTextSize(float value) {
        if (this.txtTitle == null) {
            return;
        }
        this.txtTitle.setTextSize(value);
    }

    public void setListener(OnClickItemListener listener) {
        if (listener == null) {
            return;
        }
        this.listener = listener;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cardView.setEnabled(enabled);
        if (enabled) {
            return;
        }
        this.imgIconRight.setTintColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.disable_color));
        this.imgIconLeft.setTintColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.disable_color));
        this.txtTitle.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.disable_color));
    }

    public void onClick(View view) {
        if (this.listener != null) {
            this.listener.onClickItem();
        }
    }

    private void setFontFace() {
        String fontFamily = "sansLight.ttf";
        switch (this.fontFace) {
            case 1: {
                fontFamily = "sansULight.ttf";
                break;
            }
            case 2: {
                fontFamily = "sansBold.ttf";
                break;
            }
            case 3: {
                fontFamily = "ocra.ttf";
            }
        }
        this.txtTitle.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
    }

    public static interface OnClickItemListener {
        public void onClickItem();
    }
}

