/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.zarinpal.libs.views.R;

public class ZarinProgressViewHorizontal
extends LinearLayout {
    public static final String TAG = ZarinProgressViewHorizontal.class.getSimpleName();
    private ProgressBar progressView;
    private int time;
    private int counter;
    private CounterProgressListener listener;
    private Drawable drawable;
    int millTime = 0;

    public ZarinProgressViewHorizontal(Context context) {
        super(context);
    }

    public ZarinProgressViewHorizontal(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ZarinProgressViewHorizontal);
        this.time = typedArray.getInteger(R.styleable.ZarinProgressViewHorizontal_zp_time, 5);
        this.drawable = typedArray.getDrawable(R.styleable.ZarinProgressViewHorizontal_zp_resource);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initializeView();
    }

    private void initializeView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.progress_view_horizontal, (ViewGroup)this, true);
        this.progressView = (ProgressBar)view.findViewById(R.id.custom_progress_view);
        if (this.drawable == null) {
            return;
        }
        this.progressView.setProgressDrawable(this.drawable);
    }

    public void setTime(int timeSec) {
        this.time = timeSec;
    }

    public void startProgress(final CounterProgressListener listener) {
        if (this.progressView == null) {
            return;
        }
        this.millTime = this.time * 1000;
        this.listener = listener;
        this.progressView.setMax(this.millTime);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (ZarinProgressViewHorizontal.this.counter <= ZarinProgressViewHorizontal.this.millTime) {
                        ZarinProgressViewHorizontal.this.progressView.post(new Runnable(){

                            @Override
                            public void run() {
                                ZarinProgressViewHorizontal.this.progressView.setProgress(ZarinProgressViewHorizontal.this.counter);
                                if (listener != null) {
                                    ZarinProgressViewHorizontal.this.counter = ZarinProgressViewHorizontal.this.counter + 100;
                                    ZarinProgressViewHorizontal.this.time = ZarinProgressViewHorizontal.this.time - 100;
                                    listener.onCounter(ZarinProgressViewHorizontal.this.formatsMilliSeconds(ZarinProgressViewHorizontal.this.time * -1));
                                }
                            }
                        });
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    private String formatsMilliSeconds(long milliseconds) {
        String finalTimerString = "";
        int hours = (int)(milliseconds / 3600000L);
        int minutes = (int)(milliseconds % 3600000L) / 60000;
        int seconds = (int)(milliseconds % 3600000L % 60000L / 1000L);
        if (hours > 0) {
            finalTimerString = hours + ":";
        }
        String secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
        finalTimerString = finalTimerString + minutes + " : " + secondsString;
        return finalTimerString;
    }

    public static interface CounterProgressListener {
        public void onCounter(String var1);
    }
}

