/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zarinpal.libs.views.R;
import com.zarinpal.libs.views.utitlity.FontUtility;
import com.zarinpal.libs.views.utitlity.UnitUtility;

@SuppressLint(value={"AppCompatCustomView"})
public class ZarinPanTextView
extends LinearLayout {
    private TextView txtSliceOne;
    private TextView txtSliceTwo;
    private TextView txtSliceThree;
    private TextView txtSliceFour;
    private LinearLayout layout_one;
    private LinearLayout layout_two;
    private LinearLayout layout_three;
    private LinearLayout layout_four;
    private static final int IRANSANS_LIGHT = 0;
    private static final int IRANSANS_ULIGHT = 1;
    private static final int IRANSANS_BOLD = 2;
    private static final int OCRA = 3;
    private int fontFace;
    private String cardStr;
    private Drawable backgroundDrawable;
    private float textSize;
    private float marginItem;
    private Integer textColor;

    public ZarinPanTextView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZarinPanTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ZarinPanTextView);
        try {
            this.fontFace = array.getInt(R.styleable.ZarinPanTextView_zp_fontFace, 0);
            this.cardStr = array.getString(R.styleable.ZarinPanTextView_zp_setCardNumber);
            this.backgroundDrawable = array.getDrawable(R.styleable.ZarinPanTextView_zp_backgroundNumber);
            this.textSize = array.getDimension(R.styleable.ZarinPanTextView_zp_textSize, 12.0f);
            this.marginItem = array.getDimension(R.styleable.ZarinPanTextView_zp_textSize, 4.0f);
            this.textColor = array.getColor(R.styleable.ZarinPanTextView_android_textColor, -16777216);
        }
        finally {
            array.recycle();
        }
        if (this.backgroundDrawable == null) {
            this.backgroundDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.default_bg_pan);
        }
        this.initializeView();
    }

    private void initializeView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.zarin_pan_text_view, (ViewGroup)this);
        this.txtSliceOne = (TextView)view.findViewById(R.id.txt_slice_one);
        this.txtSliceTwo = (TextView)view.findViewById(R.id.txt_slice_two);
        this.txtSliceThree = (TextView)view.findViewById(R.id.txt_slice_three);
        this.txtSliceFour = (TextView)view.findViewById(R.id.txt_slice_four);
        this.layout_one = (LinearLayout)view.findViewById(R.id.layout_one);
        this.layout_two = (LinearLayout)view.findViewById(R.id.layout_two);
        this.layout_three = (LinearLayout)view.findViewById(R.id.layout_three);
        this.layout_four = (LinearLayout)view.findViewById(R.id.layout_four);
        this.layout_one.setBackground(this.backgroundDrawable);
        this.layout_two.setBackground(this.backgroundDrawable);
        this.layout_three.setBackground(this.backgroundDrawable);
        this.layout_four.setBackground(this.backgroundDrawable);
        this.setFont();
        this.setText(this.cardStr);
    }

    public void setText(String str) {
        if (str == null) {
            return;
        }
        if (str.length() != 16) {
            return;
        }
        this.cardStr = str;
        this.txtSliceOne.setText((CharSequence)this.cardStr.substring(0, 4));
        this.txtSliceTwo.setText((CharSequence)this.cardStr.substring(4, 8));
        this.txtSliceThree.setText((CharSequence)this.cardStr.substring(8, 12));
        this.txtSliceFour.setText((CharSequence)this.cardStr.substring(12, 16));
    }

    private void setFont() {
        String fontFamily = "sansLight.ttf";
        switch (this.fontFace) {
            case 1: {
                fontFamily = "sansULight.ttf";
                break;
            }
            case 2: {
                fontFamily = "sansBold.ttf";
                break;
            }
            case 3: {
                fontFamily = "ocra.ttf";
            }
        }
        this.txtSliceOne.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
        this.txtSliceTwo.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
        this.txtSliceThree.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
        this.txtSliceFour.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
        this.textSize = UnitUtility.pxToDp(this.textSize, this.getContext());
        this.txtSliceOne.setTextSize(this.textSize);
        this.txtSliceTwo.setTextSize(this.textSize);
        this.txtSliceThree.setTextSize(this.textSize);
        this.txtSliceFour.setTextSize(this.textSize);
        int margin = (int)UnitUtility.pxToDp(this.marginItem, this.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(margin, margin, margin, margin);
        this.layout_one.setLayoutParams((ViewGroup.LayoutParams)params);
        this.layout_two.setLayoutParams((ViewGroup.LayoutParams)params);
        this.layout_three.setLayoutParams((ViewGroup.LayoutParams)params);
        this.layout_four.setLayoutParams((ViewGroup.LayoutParams)params);
        this.txtSliceOne.setTextColor(this.textColor.intValue());
        this.txtSliceTwo.setTextColor(this.textColor.intValue());
        this.txtSliceThree.setTextColor(this.textColor.intValue());
        this.txtSliceFour.setTextColor(this.textColor.intValue());
    }
}

