/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;
import com.zarinpal.libs.views.BlurBuilder;
import com.zarinpal.libs.views.utitlity.DrawableResource;

public class ZarinImageView
extends AppCompatImageView {
    private Context context;
    private boolean isBlur;
    private boolean isGradient;

    public ZarinImageView(Context context) {
        super(context);
        this.context = context;
    }

    public ZarinImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public ZarinImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    public void setOnTouchCompactListener(final OnTouchCompactListener listener) {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 1) {
                    listener.onActionUp();
                } else if (motionEvent.getAction() == 0) {
                    listener.onActionDown();
                }
                return true;
            }
        });
    }

    public void setTintColor(int color2) {
        this.setColorFilter(color2);
    }

    public void isBlur(boolean isBlur) {
        this.isBlur = isBlur;
    }

    public void loadAsyncIssuerLogoBitmap(String slug) {
        new DrawableResource(this.context).getIssuerBankLogo(slug, new DrawableResource.OnFetchIssuerBankLogoListener(){

            @Override
            public void onBitmap(Bitmap bitmap) {
                ZarinImageView.this.setImageBitmap(bitmap);
            }
        });
    }

    public void setTransitionNameCompact(String transitionName) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setTransitionName(transitionName);
        }
    }

    public int getPixelColor() {
        BitmapDrawable drawable2 = (BitmapDrawable)this.getDrawable();
        if (drawable2 != null) {
            return drawable2.getBitmap().getPixel(10, 10);
        }
        return 0;
    }

    public void loadAsyncBitmap(final String url) {
        Picasso.with((Context)this.getContext()).load(url).into(new Target(){

            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                if (ZarinImageView.this.isGradient) {
                    ZarinImageView.this.setGradient(bitmap);
                    return;
                }
                if (ZarinImageView.this.isBlur) {
                    bitmap = BlurBuilder.blur(ZarinImageView.this.getContext(), bitmap);
                    ZarinImageView.this.setImageBitmap(bitmap);
                    return;
                }
                ZarinImageView.this.setImageBitmap(bitmap);
            }

            public void onBitmapFailed(Drawable errorDrawable) {
                ZarinImageView.this.loadAsyncBitmap(url);
            }

            public void onPrepareLoad(Drawable placeHolderDrawable) {
            }
        });
    }

    public void isGradient(boolean isGradient) {
        this.isGradient = isGradient;
    }

    private void setGradient(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int bottomCenterColor = bitmap.getPixel(width / 2, height - 1);
        int topLeftColor = bitmap.getPixel(0, 0);
        int topRightColor = bitmap.getPixel(width - 1, 0);
        int centerColor = bitmap.getPixel(width / 2, height / 2);
        ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{bottomCenterColor, topLeftColor, centerColor, topRightColor});
        animator.setDuration(20000L);
        animator.setRepeatCount(-1);
        animator.setRepeatMode(2);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                GradientDrawable gradient = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{(Integer)valueAnimator.getAnimatedValue(), -1, -1, -1});
                gradient.setCornerRadius(0.0f);
                gradient.setAlpha(190);
                ZarinImageView.this.setImageDrawable((Drawable)gradient);
            }
        });
        animator.start();
    }

    public static interface OnTouchCompactListener {
        public void onActionDown();

        public void onActionUp();
    }
}

