/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.v4.view.ViewCompat;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zarinpal.libs.views.R;
import com.zarinpal.libs.views.utitlity.FontUtility;
import com.zarinpal.libs.views.utitlity.UnitUtility;
import me.zhanghai.android.materialedittext.MaterialEditText;

public class ZarinEditText
extends RelativeLayout {
    private Context context;
    private FrameLayout frmLeftFirstIcon;
    private FrameLayout frmLeftSecondIcon;
    private FrameLayout frmRightIcon;
    private ImageView imgLeftFirstIcon;
    private ImageView imgLeftSecondIcon;
    private ImageView imgRightIcon;
    private MaterialEditText editText;
    private int fontFace;
    private Drawable leftFirstIcon;
    private Drawable leftSecondIcon;
    private Drawable rightIcon;
    private float textSize;
    private int gravity;
    private String hint;
    private int maxLines;
    private int maxLength;
    private int textColor;
    private int inputType;
    private String text;
    private int textColorHint;
    private int activeColor;

    public ZarinEditText(Context context) {
        super(context);
        this.context = context;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZarinEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ZarinEditText);
        try {
            this.fontFace = array.getInt(R.styleable.ZarinEditText_zp_fontFace, 0);
            this.leftFirstIcon = array.getDrawable(R.styleable.ZarinEditText_zp_leftFirstIcon);
            this.leftSecondIcon = array.getDrawable(R.styleable.ZarinEditText_zp_leftSecondIcon);
            this.rightIcon = array.getDrawable(R.styleable.ZarinEditText_zp_rightIcon);
            this.textSize = array.getDimension(R.styleable.ZarinEditText_android_textSize, 0.0f);
            this.gravity = array.getInt(R.styleable.ZarinEditText_android_gravity, 5);
            this.hint = array.getString(R.styleable.ZarinEditText_android_hint);
            this.maxLines = array.getInt(R.styleable.ZarinEditText_android_maxLines, 0);
            this.maxLength = array.getInt(R.styleable.ZarinEditText_android_maxLength, 0);
            this.textColor = array.getColor(R.styleable.ZarinEditText_android_textColor, 0);
            this.inputType = array.getInt(R.styleable.ZarinEditText_android_inputType, 0);
            this.text = array.getString(R.styleable.ZarinEditText_android_text);
            this.textColorHint = array.getColor(R.styleable.ZarinEditText_android_textColorHint, 0);
            this.activeColor = array.getColor(R.styleable.ZarinEditText_zp_activeColor, 0);
        }
        finally {
            array.recycle();
        }
        this.initialize();
    }

    public ZarinEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initialize();
    }

    private void initialize() {
        View layout2 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.zarin_edit_text, (ViewGroup)this, true);
        this.frmLeftFirstIcon = (FrameLayout)layout2.findViewById(R.id.frm_left_first_icon);
        this.frmLeftSecondIcon = (FrameLayout)layout2.findViewById(R.id.frm_left_second_icon);
        this.frmRightIcon = (FrameLayout)layout2.findViewById(R.id.frm_right_icon);
        this.imgLeftFirstIcon = (ImageView)layout2.findViewById(R.id.img_left_first_icon);
        this.imgLeftSecondIcon = (ImageView)layout2.findViewById(R.id.img_left_second_icon);
        this.imgRightIcon = (ImageView)layout2.findViewById(R.id.img_right_icon);
        this.editText = (MaterialEditText)layout2.findViewById(R.id.edit_text);
        this.setIcons();
        this.setFontFace();
        this.editText.setGravity(this.gravity);
        if (this.textSize != 0.0f) {
            this.editText.setTextSize(UnitUtility.pxToDp(this.textSize, this.getContext()));
        }
        this.editText.setHint((CharSequence)this.hint);
        if (this.maxLines != 0) {
            this.editText.setMaxLines(this.maxLines);
        }
        if (this.maxLength != 0) {
            this.editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.maxLength)});
        }
        if (this.textColor != 0) {
            this.editText.setTextColor(this.textColor);
        }
        if (this.inputType != 0) {
            this.editText.setInputType(this.inputType);
        }
        this.editText.setText((CharSequence)this.text);
        this.editText.setHintTextColor(this.textColorHint);
        if (this.activeColor != 0) {
            ViewCompat.setBackgroundTintList((View)this.editText, (ColorStateList)ColorStateList.valueOf((int)this.activeColor));
        }
    }

    private void setIcons() {
        int rightMargin = 0;
        int leftPadding = 0;
        if (this.rightIcon != null) {
            this.frmRightIcon.setVisibility(0);
            this.imgRightIcon.setImageDrawable(this.rightIcon);
            rightMargin = (int)UnitUtility.dpToPx(this.getContext(), 50);
        }
        if (this.leftFirstIcon != null) {
            this.frmLeftFirstIcon.setVisibility(0);
            this.imgLeftFirstIcon.setImageDrawable(this.leftFirstIcon);
            leftPadding = (int)UnitUtility.dpToPx(this.getContext(), 50);
        }
        if (this.leftSecondIcon != null) {
            this.frmLeftSecondIcon.setVisibility(0);
            this.imgLeftSecondIcon.setImageDrawable(this.leftSecondIcon);
            leftPadding = (int)((float)leftPadding + UnitUtility.dpToPx(this.getContext(), 45));
        }
        if (rightMargin == 0 && leftPadding == 0) {
            return;
        }
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.editText.getLayoutParams();
        params.setMargins(0, 0, rightMargin, 0);
        this.editText.setLayoutParams((ViewGroup.LayoutParams)params);
        this.editText.setPadding(leftPadding, this.editText.getPaddingTop(), this.editText.getPaddingRight(), this.editText.getPaddingBottom());
    }

    private void setFontFace() {
        String fontFamily = "sansLight.ttf";
        switch (this.fontFace) {
            case 1: {
                fontFamily = "sansULight.ttf";
                break;
            }
            case 2: {
                fontFamily = "sansBold.ttf";
                break;
            }
            case 3: {
                fontFamily = "ocra.ttf";
            }
        }
        this.editText.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
    }

    public void setRightIcon(@DrawableRes int icon) {
        this.rightIcon = this.context.getResources().getDrawable(icon);
        this.setIcons();
    }

    public void setLeftFirstIcon(@DrawableRes int icon) {
        this.leftFirstIcon = this.context.getResources().getDrawable(icon);
    }

    public void setLeftSecondIcon(@DrawableRes int icon) {
        this.leftSecondIcon = this.context.getResources().getDrawable(icon);
    }

    public FrameLayout getRightIcon() {
        return this.frmRightIcon;
    }

    public FrameLayout getLeftFirstIcon() {
        return this.frmLeftFirstIcon;
    }

    public FrameLayout getFrmLeftSecondIcon() {
        return this.frmLeftSecondIcon;
    }

    public MaterialEditText getEditText() {
        return this.editText;
    }
}

