/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.ewallets.purchase;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.zarinpal.ewallets.purchase.HttpRequest;
import com.zarinpal.ewallets.purchase.HttpRequestListener;
import com.zarinpal.ewallets.purchase.OnCallbackRequestPaymentListener;
import com.zarinpal.ewallets.purchase.OnCallbackVerificationPaymentListener;
import com.zarinpal.ewallets.purchase.PaymentRequest;
import com.zarinpal.ewallets.purchase.SandboxPaymentRequest;
import com.zarinpal.ewallets.purchase.VerificationPayment;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"StaticFieldLeak"})
public class ZarinPal {
    private static ZarinPal instance;
    private Context context;
    private PaymentRequest paymentRequest;

    public static ZarinPal getPurchase(Context context) {
        if (instance == null) {
            instance = new ZarinPal(context);
        }
        return instance;
    }

    public static PaymentRequest getPaymentRequest() {
        return new PaymentRequest();
    }

    public static SandboxPaymentRequest getSandboxPaymentRequest() {
        return new SandboxPaymentRequest();
    }

    private ZarinPal(Context context) {
        this.context = context;
    }

    public void verificationPayment(Uri uri, final OnCallbackVerificationPaymentListener listener) {
        if (uri == null || this.paymentRequest == null || !uri.isHierarchical()) {
            return;
        }
        boolean isSuccess = uri.getQueryParameter("Status").equals("OK");
        String authority = uri.getQueryParameter("Authority");
        if (!authority.equals(this.paymentRequest.getAuthority())) {
            listener.onCallbackResultVerificationPayment(false, null, this.paymentRequest);
            return;
        }
        if (!isSuccess) {
            listener.onCallbackResultVerificationPayment(false, null, this.paymentRequest);
            return;
        }
        VerificationPayment verificationPayment = new VerificationPayment();
        verificationPayment.setAmount(this.paymentRequest.getAmount());
        verificationPayment.setMerchantID(this.paymentRequest.getMerchantID());
        verificationPayment.setAuthority(authority);
        try {
            new HttpRequest(this.context, this.paymentRequest.getVerificationPaymentURL()).setJson(verificationPayment.getVerificationPaymentAsJson()).setRequestMethod(1).setRequestType((byte)0).get(new HttpRequestListener(){

                @Override
                public void onSuccessResponse(JSONObject jsonObject, String contentResponse) {
                    try {
                        String refID = jsonObject.getString("RefID");
                        listener.onCallbackResultVerificationPayment(true, refID, ZarinPal.this.paymentRequest);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailureResponse(int httpStatusCode, String dataError) {
                    listener.onCallbackResultVerificationPayment(false, null, ZarinPal.this.paymentRequest);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startPayment(final PaymentRequest paymentRequest, final OnCallbackRequestPaymentListener listener) {
        this.paymentRequest = paymentRequest;
        try {
            new HttpRequest(this.context, paymentRequest.getPaymentRequestURL()).setRequestType((byte)0).setRequestMethod(1).setJson(paymentRequest.getPaymentRequestAsJson()).get(new HttpRequestListener(){

                @Override
                public void onSuccessResponse(JSONObject jsonObject, String contentResponse) {
                    try {
                        int status = jsonObject.getInt("Status");
                        String authority = jsonObject.getString("Authority");
                        paymentRequest.setAuthority(authority);
                        Uri uri = Uri.parse((String)paymentRequest.getStartPaymentGatewayURL(authority));
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        listener.onCallbackResultPaymentRequest(status, authority, uri, intent);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailureResponse(int httpStatusCode, String dataError) {
                    try {
                        JSONObject object = new JSONObject(dataError);
                        int status = object.getInt("Status");
                        listener.onCallbackResultPaymentRequest(status, null, null, null);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

