/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.ewallets.purchase;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.zarinpal.ewallets.purchase.HttpRequest;
import com.zarinpal.ewallets.purchase.HttpRequestListener;
import com.zarinpal.ewallets.purchase.OnCallbackRequestPaymentListener;
import com.zarinpal.ewallets.purchase.OnCallbackVerificationPaymentListener;
import com.zarinpal.ewallets.purchase.PaymentRequest;
import com.zarinpal.ewallets.purchase.URLPaymentBuilder;
import com.zarinpal.ewallets.purchase.VerificationPayment;
import org.json.JSONException;
import org.json.JSONObject;

public class ZarinPal {
    private static final String PAYMENT_REQUEST_URL = "https://www.zarinpal.com/pg/rest/WebGate/PaymentRequest.json";
    private static final String VERIFICATION_PAYMENT_URL = "https://www.zarinpal.com/pg/rest/WebGate/PaymentVerification.json";
    private static ZarinPal instance;
    private static Context mContext;
    private PaymentRequest paymentRequest;

    public static ZarinPal getPurchase(Context context) {
        if (instance == null) {
            instance = new ZarinPal();
            mContext = context;
        }
        return instance;
    }

    public static PaymentRequest getPaymentRequest() {
        return new PaymentRequest();
    }

    private ZarinPal() {
    }

    public void verificationPayment(Uri uri, final OnCallbackVerificationPaymentListener listener) {
        if (uri == null || this.paymentRequest == null || !uri.isHierarchical()) {
            return;
        }
        boolean isSuccess = uri.getQueryParameter("Status").equals("OK");
        String authority = uri.getQueryParameter("Authority");
        if (!authority.equals(this.paymentRequest.getAuthority())) {
            listener.onCallbackResultVerificationPayment(false, null, this.paymentRequest);
            return;
        }
        if (!isSuccess) {
            listener.onCallbackResultVerificationPayment(false, null, this.paymentRequest);
            return;
        }
        VerificationPayment verificationPayment = new VerificationPayment();
        verificationPayment.setAmount(this.paymentRequest.getAmount());
        verificationPayment.setMerchantID(this.paymentRequest.getMerchantID());
        verificationPayment.setAuthority(authority);
        try {
            new HttpRequest(mContext, VERIFICATION_PAYMENT_URL).setJson(verificationPayment.getVerificationPaymentAsJson()).setRequestMethod(1).setRequestType((byte)0).get(new HttpRequestListener(){

                @Override
                public void onSuccessResponse(JSONObject jsonObject, String contentResponse) {
                    try {
                        String refID = jsonObject.getString("RefID");
                        listener.onCallbackResultVerificationPayment(true, refID, ZarinPal.this.paymentRequest);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailureResponse(int httpStatusCode, String dataError) {
                    listener.onCallbackResultVerificationPayment(false, null, ZarinPal.this.paymentRequest);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startPayment(final PaymentRequest paymentRequest, final OnCallbackRequestPaymentListener listener) {
        this.paymentRequest = paymentRequest;
        try {
            new HttpRequest(mContext, PAYMENT_REQUEST_URL).setRequestType((byte)0).setRequestMethod(1).setJson(paymentRequest.getPaymentRequestAsJson()).get(new HttpRequestListener(){

                @Override
                public void onSuccessResponse(JSONObject jsonObject, String contentResponse) {
                    try {
                        int status = jsonObject.getInt("Status");
                        String authority = jsonObject.getString("Authority");
                        paymentRequest.setAuthority(authority);
                        Uri uri = Uri.parse((String)URLPaymentBuilder.getAuthorityPaymentURL(authority));
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        listener.onCallbackResultPaymentRequest(status, authority, uri, intent);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailureResponse(int httpStatusCode, String dataError) {
                    try {
                        JSONObject object = new JSONObject(dataError);
                        int status = object.getInt("Status");
                        listener.onCallbackResultPaymentRequest(status, null, null, null);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

