package com.zarinpal.ewallets.purchase;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Android ZarinPal In App Purchase SDK Library v0.0.2 Beta Project.
 * Created by ImanX on 12/22/16.
 * Copyright Alireza Tarazani All Rights Reserved.
 */
public class PaymentRequest extends Payment {


    private String merchantID;
    private long   amount;
    private String mobile;
    private String email;
    private String description;
    private String callBackURL;
    private String authority;


    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }

    public void setCallbackURL(String callBackURL) {
        this.callBackURL = callBackURL;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCallBackURL() {
        return callBackURL;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public long getAmount() {
        return amount;
    }


    public String getDescription() {
        return description;
    }


    public String getMobile() {
        return mobile;
    }


    public String getMerchantID() {
        return merchantID;
    }

    public String getEmail() {
        return email;
    }

    public String getAuthority() {
        return authority;
    }

    public JSONObject getPaymentRequestAsJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(MERCHANT_ID_PARAMS, getMerchantID());
        jsonObject.put(AMOUNT_PARAMS, getAmount());
        jsonObject.put(DESCRIPTION_PARAMS, getDescription());
        jsonObject.put(CALLBACK_URL_PARAMS, getCallBackURL());
        jsonObject.put(MOBILE_PARAMS, getMobile());
        jsonObject.put(EMAIL_PARAMS, getEmail());
        return jsonObject;
    }


}
