/*
 * Decompiled with CFR 0.152.
 */
package com.zandero.http.logging;

import com.zandero.http.RequestUtils;
import com.zandero.utils.StringUtils;
import com.zandero.utils.extra.UrlUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

@Deprecated
public final class LoggingUtils {
    private LoggingUtils() {
    }

    public static void prepareForLogging(HttpServletRequest request) {
        MDC.put((String)"timestamp", (String)("" + System.currentTimeMillis()));
        MDC.put((String)"request_id", (String)UUID.randomUUID().toString());
        MDC.put((String)"request", (String)request.getRequestURI());
        MDC.put((String)"ip", (String)RequestUtils.getClientIpAddress(request));
        MDC.put((String)"user_agent", (String)RequestUtils.getUserAgent(request));
        MDC.put((String)"method", (String)request.getMethod());
        MDC.put((String)"host", (String)request.getServerName());
        MDC.put((String)"scheme", (String)RequestUtils.getScheme(request));
        MDC.put((String)"domain", (String)UrlUtils.resolveDomain((String)request.getServerName()));
        MDC.put((String)"port", (String)("" + request.getServerPort()));
        MDC.put((String)"path", (String)(request.getContextPath() + request.getPathInfo()));
        if (request.getUserPrincipal() != null) {
            MDC.put((String)"user", request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null);
        }
        if (!StringUtils.isNullOrEmptyTrimmed((String)request.getQueryString())) {
            MDC.put((String)"query", (String)request.getQueryString());
        }
    }

    public static void prepareForLogging(String path, String query) {
        MDC.put((String)"request_id", (String)UUID.randomUUID().toString());
        try {
            URI uri = new URI(path);
            MDC.put((String)"host", (String)uri.getHost());
            MDC.put((String)"scheme", (String)uri.getScheme());
            MDC.put((String)"domain", (String)UrlUtils.resolveDomain((String)uri.getPath()));
            MDC.put((String)"port", (String)("" + uri.getPort()));
            MDC.put((String)"path", (String)uri.getPath());
        }
        catch (URISyntaxException e) {
            MDC.put((String)"path", (String)path);
        }
        MDC.put((String)"timestamp", (String)("" + System.currentTimeMillis()));
        if (!StringUtils.isNullOrEmptyTrimmed((String)query)) {
            MDC.put((String)"query", (String)query);
        }
    }
}

