/*
 * Decompiled with CFR 0.152.
 */
package com.zandero.http;

import com.zandero.utils.StringUtils;
import com.zandero.utils.extra.UrlUtils;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.net.util.SubnetUtils;

public final class RequestUtils {
    private RequestUtils() {
    }

    public static String getUserAgent(HttpServletRequest request) {
        return RequestUtils.getHeader(request, "User-Agent");
    }

    private static String getCookie(Cookie[] cookies, String name) {
        if (cookies == null || cookies.length == 0 || StringUtils.isNullOrEmptyTrimmed((String)name)) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!StringUtils.equals((String)cookie.getName(), (String)name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getHeader(HttpServletRequest request, String header) {
        if (request == null || StringUtils.isNullOrEmptyTrimmed((String)header)) {
            return null;
        }
        return request.getHeader(header);
    }

    public static String getDomain(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return UrlUtils.resolveDomain((String)request.getServerName());
    }

    public static String getScheme(HttpServletRequest request) {
        String scheme = request.getHeader("X-Forwarded-Proto");
        if (StringUtils.isNullOrEmptyTrimmed((String)scheme)) {
            scheme = request.getScheme();
        }
        return scheme != null ? scheme.trim().toLowerCase() : null;
    }

    public static String getClientIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static boolean isIpAddressAllowed(String ipAddress, String ... whitelist) {
        if (StringUtils.isNullOrEmpty((String)ipAddress) || whitelist == null || whitelist.length == 0) {
            return false;
        }
        for (String address : whitelist) {
            if (ipAddress.equals(address)) {
                return true;
            }
            if (!address.contains("/")) continue;
            SubnetUtils utils = new SubnetUtils(address);
            utils.setInclusiveHostCount(true);
            if (!utils.getInfo().isInRange(ipAddress)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkBasicAuth(HttpServletRequest servletRequest, String username, String password) {
        String basicAuth = servletRequest.getHeader("Authorization");
        if (StringUtils.isNullOrEmptyTrimmed((String)basicAuth) || !basicAuth.startsWith("Basic ")) {
            return false;
        }
        String base64Credentials = basicAuth.substring("Basic".length()).trim();
        String credentials = new String(Base64.getDecoder().decode(base64Credentials), Charset.forName("UTF-8"));
        String[] values = credentials.split(":", 2);
        if (values.length != 2) {
            return false;
        }
        return StringUtils.equals((String)values[0], (String)username) && StringUtils.equals((String)values[1], (String)password);
    }
}

