/*
 * Decompiled with CFR 0.152.
 */
package com.zandero.http;

import com.zandero.utils.Assert;
import com.zandero.utils.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    public static final String UTF_8 = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final int TIME_OUT_IN_SECONDS = 30;

    private HttpUtils() {
    }

    public static HttpRequestBase get(String path) {
        return HttpUtils.get(path, null, null);
    }

    public static HttpRequestBase get(String path, Map<String, String> headers, Integer timeOutInSeconds) {
        HttpGet get = new HttpGet(path);
        HttpUtils.addHeaders((HttpRequest)get, headers);
        get.setConfig(HttpUtils.getConfig(timeOutInSeconds));
        return get;
    }

    public static HttpRequestBase post(String path) {
        return HttpUtils.post(path, null, null, null);
    }

    public static HttpRequestBase post(String path, Map<String, String> headers, Map<String, String> parameters, HttpEntity entity, Integer timeOutInSeconds) {
        HttpPost post = new HttpPost(path);
        HttpUtils.addHeaders((HttpRequest)post, headers);
        HttpUtils.addParameters((HttpEntityEnclosingRequestBase)post, parameters);
        post.setConfig(HttpUtils.getConfig(timeOutInSeconds));
        if (entity != null) {
            post.setEntity(entity);
        }
        return post;
    }

    public static HttpRequestBase post(String path, Map<String, String> headers, Map<String, String> parameters, Integer timeOutInSeconds) {
        return HttpUtils.post(path, headers, parameters, null, timeOutInSeconds);
    }

    public static HttpRequestBase put(String path, HttpEntity entity) {
        return HttpUtils.put(path, null, null, entity, null);
    }

    public static HttpRequestBase put(String path, Map<String, String> headers, Map<String, String> parameters, HttpEntity entity, Integer timeOutInSeconds) {
        HttpPut put = new HttpPut(path);
        HttpUtils.addHeaders((HttpRequest)put, headers);
        HttpUtils.addParameters((HttpEntityEnclosingRequestBase)put, parameters);
        put.setConfig(HttpUtils.getConfig(timeOutInSeconds));
        if (entity != null) {
            put.setEntity(entity);
        }
        return put;
    }

    public static HttpRequestBase put(String path, Map<String, String> headers, Map<String, String> parameters, Integer timeOutInSeconds) {
        return HttpUtils.put(path, headers, parameters, null, timeOutInSeconds);
    }

    public static HttpRequestBase patch(String path, Map<String, String> headers, Map<String, String> parameters, HttpEntity entity, Integer timeOutInSeconds) {
        HttpPatch patch = new HttpPatch(path);
        HttpUtils.addHeaders((HttpRequest)patch, headers);
        HttpUtils.addParameters((HttpEntityEnclosingRequestBase)patch, parameters);
        patch.setConfig(HttpUtils.getConfig(timeOutInSeconds));
        if (entity != null) {
            patch.setEntity(entity);
        }
        return patch;
    }

    public static HttpRequestBase patch(String path) {
        return HttpUtils.patch(path, null, null, null);
    }

    public static HttpRequestBase patch(String path, Map<String, String> headers, Map<String, String> parameters, Integer timeOutInSeconds) {
        return HttpUtils.patch(path, headers, parameters, null, timeOutInSeconds);
    }

    public static HttpRequestBase delete(String path) {
        return HttpUtils.delete(path, null, null);
    }

    public static HttpRequestBase delete(String path, Map<String, String> headers, Integer timeOutInSeconds) {
        HttpDelete delete = new HttpDelete(path);
        HttpUtils.addHeaders((HttpRequest)delete, headers);
        delete.setConfig(HttpUtils.getConfig(timeOutInSeconds));
        return delete;
    }

    public static HttpResponse execute(HttpRequestBase request) throws IOException {
        Assert.notNull((Object)request, (String)"Missing request!");
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
        return client.execute((HttpUriRequest)request);
    }

    public static void executeAsync(Executor executor, HttpRequestBase request, FutureCallback<HttpResponse> callback) {
        try {
            executor.execute(new AsyncHttpCall(request, callback));
        }
        catch (Exception e) {
            log.error("Failed to execute asynchronously: " + request.getMethod() + " " + request.getURI().toString());
        }
    }

    public static String getContentAsString(HttpResponse response) {
        try {
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                Header contentEncoding = entity.getContentEncoding();
                String encoding = contentEncoding != null ? contentEncoding.getValue() : UTF_8;
                return ResourceUtils.getString((InputStream)entity.getContent(), (String)encoding);
            }
        }
        catch (IOException e) {
            log.error("Failed to read response: ", (Object)e.getMessage());
        }
        return null;
    }

    public static byte[] getContent(HttpResponse response) {
        try {
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                return ResourceUtils.getBytes((InputStream)response.getEntity().getContent());
            }
        }
        catch (IOException e) {
            log.error("Failed to read response: ", (Object)e.getMessage());
        }
        return null;
    }

    private static void addHeaders(HttpRequest request, Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (String name : headers.keySet()) {
                request.setHeader((Header)new BasicHeader(name, headers.get(name)));
            }
        }
    }

    private static void addParameters(HttpEntityEnclosingRequestBase requestBase, Map<String, String> parameters) {
        if (parameters != null && parameters.size() > 0) {
            try {
                List params = parameters.keySet().stream().map(name -> new BasicNameValuePair(name, (String)parameters.get(name))).collect(Collectors.toList());
                requestBase.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Cant encode parameters!", e);
            }
        }
    }

    private static RequestConfig getConfig(Integer timeOutInSeconds) {
        if (timeOutInSeconds == null) {
            timeOutInSeconds = 30;
        }
        int timeOut = timeOutInSeconds * 1000;
        return RequestConfig.custom().setSocketTimeout(timeOut).setConnectTimeout(timeOut).setConnectionRequestTimeout(timeOut).build();
    }

    private static class AsyncHttpCall
    implements Runnable {
        private final HttpRequestBase request;
        private final FutureCallback<HttpResponse> callback;

        AsyncHttpCall(HttpRequestBase req, FutureCallback<HttpResponse> back) {
            this.request = req;
            this.callback = back;
        }

        @Override
        public void run() {
            try (CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();){
                client.start();
                Future future = client.execute((HttpUriRequest)this.request, this.callback);
                HttpResponse response = (HttpResponse)future.get();
                log.info("Request: " + this.request.getURI().toString() + " -> " + response.getStatusLine().getStatusCode());
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                log.error("Failed to execute request: " + this.request);
            }
        }
    }
}

