/*
 * Decompiled with CFR 0.152.
 */
package com.zandero.http;

import com.zandero.utils.extra.UrlUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Http {
    private static final Logger log = LoggerFactory.getLogger(Http.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private static SSLSocketFactory sslFactory;

    private Http() {
    }

    public static void setSSLSocketFactory(SSLSocketFactory factory) {
        sslFactory = factory;
    }

    public static Response get(String url) throws HttpException {
        return Http.get(url, null, null, 3000, 5000);
    }

    public static Response get(String url, Map<String, String> query) throws HttpException {
        return Http.get(url, query, null, 3000, 5000);
    }

    public static Response get(String url, Map<String, String> query, Map<String, String> headers) throws HttpException {
        return Http.get(url, query, headers, 3000, 5000);
    }

    public static Response get(String url, Map<String, String> query, Map<String, String> headers, int connectTimeOut, int readTimeOut) throws HttpException {
        return Http.execute("GET", url, null, query, headers, connectTimeOut, readTimeOut);
    }

    public static Response post(String url, String body) throws HttpException {
        return Http.post(url, body, null, null, 3000, 5000);
    }

    public static Response post(String url, String body, Map<String, String> query) throws HttpException {
        return Http.post(url, body, query, null, 3000, 5000);
    }

    public static Response post(String url, String body, Map<String, String> query, Map<String, String> headers) throws HttpException {
        return Http.post(url, body, query, headers, 3000, 5000);
    }

    public static Response post(String url, String body, Map<String, String> query, Map<String, String> headers, int connectTimeOut, int readTimeOut) throws HttpException {
        return Http.execute("POST", url, body, query, headers, connectTimeOut, readTimeOut);
    }

    public static Response put(String url, String body) throws HttpException {
        return Http.put(url, body, null, null, 3000, 5000);
    }

    public static Response put(String url, String body, Map<String, String> query) throws HttpException {
        return Http.put(url, body, query, null, 3000, 5000);
    }

    public static Response put(String url, String body, Map<String, String> query, Map<String, String> headers) throws HttpException {
        return Http.put(url, body, query, headers, 3000, 5000);
    }

    public static Response put(String url, String body, Map<String, String> query, Map<String, String> headers, int connectTimeOut, int readTimeOut) throws HttpException {
        return Http.execute("PUT", url, body, query, headers, connectTimeOut, readTimeOut);
    }

    public static Response delete(String url) throws HttpException {
        return Http.delete(url, null, null, 3000, 5000);
    }

    public static Response delete(String url, Map<String, String> query) throws HttpException {
        return Http.delete(url, query, null, 3000, 5000);
    }

    public static Response delete(String url, Map<String, String> query, Map<String, String> headers) throws HttpException {
        return Http.delete(url, query, headers, 3000, 5000);
    }

    public static Response delete(String url, Map<String, String> query, Map<String, String> headers, int connectTimeOut, int readTimeOut) throws HttpException {
        return Http.execute("DELETE", url, null, query, headers, connectTimeOut, readTimeOut);
    }

    private static Response execute(String method, String apiUrl, String body, Map<String, String> query, Map<String, String> headers, int connectTimeOut, int readTimeOut) throws HttpException {
        HttpURLConnection conn = null;
        int responseCode = 500;
        try {
            InputStreamReader inputStream;
            if (query != null && query.size() > 0) {
                apiUrl = UrlUtils.composeUrl((String)apiUrl, query);
            }
            URL url = new URL(apiUrl);
            if (apiUrl.toLowerCase().startsWith("https://")) {
                conn = (HttpsURLConnection)url.openConnection();
                if (sslFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sslFactory);
                }
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            conn.setConnectTimeout(connectTimeOut);
            conn.setReadTimeout(readTimeOut);
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod(method);
            byte[] postData = null;
            if (body != null) {
                postData = body.getBytes(StandardCharsets.UTF_8);
            }
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (postData != null) {
                conn.setDoInput(true);
                int postDataLength = postData.length;
                conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                OutputStream os = conn.getOutputStream();
                os.write(postData);
            }
            responseCode = conn.getResponseCode();
            BufferedReader reader = null;
            if (responseCode < 400) {
                inputStream = new InputStreamReader(conn.getInputStream());
                reader = new BufferedReader(inputStream);
            } else if (conn.getErrorStream() != null) {
                inputStream = new InputStreamReader(conn.getErrorStream());
                reader = new BufferedReader(inputStream);
            }
            StringBuilder content = new StringBuilder();
            if (reader != null) {
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
            }
            log.debug("Output from request: {} - {}", (Object)responseCode, (Object)content);
            Response response = new Response(responseCode, content.toString(), conn.getHeaderFields());
            return response;
        }
        catch (Exception e) {
            log.error("Failed execute request to: {}", (Object)apiUrl, (Object)e);
            throw new HttpException(responseCode, e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static class Response {
        private final int code;
        private final String response;
        private Map<String, List<String>> headers;

        public Response(int statusCode, String requestResponse, Map<String, List<String>> headerFields) {
            this.code = statusCode;
            this.response = requestResponse;
            this.headers = headerFields;
        }

        public int getCode() {
            return this.code;
        }

        public String getResponse() {
            return this.response;
        }

        public boolean is(int ... status) {
            if (status.length == 0) {
                return false;
            }
            for (int expected : status) {
                if (expected != this.code) continue;
                return true;
            }
            return false;
        }

        public boolean not(int ... status) {
            return !this.is(status);
        }

        public List<String> getHeaders(String name) {
            return this.headers.get(name);
        }

        public String getHeader(String name) {
            List<String> found = this.headers.get(name);
            if (found != null && found.size() > 0) {
                return found.get(0);
            }
            return null;
        }
    }

    public static class HttpException
    extends Exception {
        private final int code;

        public HttpException(int statusCode, String message) {
            super(message);
            this.code = statusCode;
        }

        public int getCode() {
            return this.code;
        }
    }
}

