/*
 * Decompiled with CFR 0.152.
 */
package com.zaaach.toprightmenu;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zaaach.toprightmenu.MenuItem;
import com.zaaach.toprightmenu.R;
import com.zaaach.toprightmenu.TopRightMenu;
import java.util.List;

public class TRMenuAdapter
extends RecyclerView.Adapter<TRMViewHolder> {
    private Context mContext;
    private List<MenuItem> menuItemList;
    private boolean showIcon;
    private TopRightMenu mTopRightMenu;
    private TopRightMenu.OnMenuItemClickListener onMenuItemClickListener;

    public TRMenuAdapter(Context context, TopRightMenu topRightMenu, List<MenuItem> menuItemList, boolean show) {
        this.mContext = context;
        this.mTopRightMenu = topRightMenu;
        this.menuItemList = menuItemList;
        this.showIcon = show;
    }

    public void setData(List<MenuItem> data) {
        this.menuItemList = data;
        this.notifyDataSetChanged();
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
        this.notifyDataSetChanged();
    }

    public TRMViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.trm_item_popup_menu_list, parent, false);
        return new TRMViewHolder(view);
    }

    public void onBindViewHolder(TRMViewHolder holder, int position) {
        MenuItem menuItem = this.menuItemList.get(position);
        if (this.showIcon) {
            holder.icon.setVisibility(0);
            int resId = menuItem.getIcon();
            holder.icon.setImageResource(resId < 0 ? 0 : resId);
        } else {
            holder.icon.setVisibility(8);
        }
        holder.text.setText((CharSequence)menuItem.getText());
        if (position == 0) {
            holder.container.setBackgroundDrawable((Drawable)this.addStateDrawable(this.mContext, -1, R.drawable.trm_popup_top_pressed));
        } else if (position == this.menuItemList.size() - 1) {
            holder.container.setBackgroundDrawable((Drawable)this.addStateDrawable(this.mContext, -1, R.drawable.trm_popup_bottom_pressed));
        } else {
            holder.container.setBackgroundDrawable((Drawable)this.addStateDrawable(this.mContext, -1, R.drawable.trm_popup_middle_pressed));
        }
        final int pos = holder.getAdapterPosition();
        holder.container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TRMenuAdapter.this.onMenuItemClickListener != null) {
                    TRMenuAdapter.this.mTopRightMenu.dismiss();
                    TRMenuAdapter.this.onMenuItemClickListener.onMenuItemClick(pos);
                }
            }
        });
    }

    private StateListDrawable addStateDrawable(Context context, int normalId, int pressedId) {
        StateListDrawable sd = new StateListDrawable();
        Drawable normal = normalId == -1 ? null : context.getResources().getDrawable(normalId);
        Drawable pressed = pressedId == -1 ? null : context.getResources().getDrawable(pressedId);
        sd.addState(new int[]{16842919}, pressed);
        sd.addState(new int[0], normal);
        return sd;
    }

    public int getItemCount() {
        return this.menuItemList == null ? 0 : this.menuItemList.size();
    }

    public void setOnMenuItemClickListener(TopRightMenu.OnMenuItemClickListener listener) {
        this.onMenuItemClickListener = listener;
    }

    class TRMViewHolder
    extends RecyclerView.ViewHolder {
        ViewGroup container;
        ImageView icon;
        TextView text;

        TRMViewHolder(View itemView) {
            super(itemView);
            this.container = (ViewGroup)itemView;
            this.icon = (ImageView)itemView.findViewById(R.id.trm_menu_item_icon);
            this.text = (TextView)itemView.findViewById(R.id.trm_menu_item_text);
        }
    }
}

