/*
 * Decompiled with CFR 0.152.
 */
package com.zaaach.toprightmenu;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.zaaach.toprightmenu.MenuItem;
import com.zaaach.toprightmenu.R;
import com.zaaach.toprightmenu.TRMenuAdapter;
import java.util.ArrayList;
import java.util.List;

public class TopRightMenu {
    private Activity mContext;
    private PopupWindow mPopupWindow;
    private RecyclerView mRecyclerView;
    private View content;
    private TRMenuAdapter mAdapter;
    private List<MenuItem> menuItemList;
    private static final int DEFAULT_HEIGHT = 480;
    private int popHeight = 480;
    private int popWidth = -2;
    private boolean showIcon = true;
    private boolean dimBackground = true;
    private boolean needAnimationStyle = true;
    private static final int DEFAULT_ANIM_STYLE = R.style.TRM_ANIM_STYLE;
    private int animationStyle;
    private float alpha = 0.75f;

    public TopRightMenu(Activity context) {
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.content = LayoutInflater.from((Context)this.mContext).inflate(R.layout.trm_popup_menu, null);
        this.mRecyclerView = (RecyclerView)this.content.findViewById(R.id.trm_recyclerview);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.mContext, 1, false));
        this.mRecyclerView.setOverScrollMode(2);
        this.menuItemList = new ArrayList<MenuItem>();
        this.mAdapter = new TRMenuAdapter((Context)this.mContext, this, this.menuItemList, this.showIcon);
    }

    private PopupWindow getPopupWindow() {
        this.mPopupWindow = new PopupWindow((Context)this.mContext);
        this.mPopupWindow.setContentView(this.content);
        this.mPopupWindow.setHeight(this.popHeight);
        this.mPopupWindow.setWidth(this.popWidth);
        if (this.needAnimationStyle) {
            this.mPopupWindow.setAnimationStyle(this.animationStyle <= 0 ? DEFAULT_ANIM_STYLE : this.animationStyle);
        }
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.mPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (TopRightMenu.this.dimBackground) {
                    TopRightMenu.this.setBackgroundAlpha(TopRightMenu.this.alpha, 1.0f, 300);
                }
            }
        });
        this.mAdapter.setData(this.menuItemList);
        this.mAdapter.setShowIcon(this.showIcon);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        return this.mPopupWindow;
    }

    public TopRightMenu setHeight(int height) {
        this.popHeight = height <= 0 && height != -1 && height != -2 ? 480 : height;
        return this;
    }

    public TopRightMenu setWidth(int width) {
        this.popWidth = width <= 0 && width != -1 ? -2 : width;
        return this;
    }

    public TopRightMenu showIcon(boolean show) {
        this.showIcon = show;
        return this;
    }

    public TopRightMenu addMenuItem(MenuItem item) {
        this.menuItemList.add(item);
        return this;
    }

    public TopRightMenu addMenuList(List<MenuItem> list) {
        this.menuItemList.addAll(list);
        return this;
    }

    public TopRightMenu dimBackground(boolean b) {
        this.dimBackground = b;
        return this;
    }

    public TopRightMenu needAnimationStyle(boolean need) {
        this.needAnimationStyle = need;
        return this;
    }

    public TopRightMenu setAnimationStyle(int style2) {
        this.animationStyle = style2;
        return this;
    }

    public TopRightMenu setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mAdapter.setOnMenuItemClickListener(listener);
        return this;
    }

    public TopRightMenu showAsDropDown(View anchor) {
        this.showAsDropDown(anchor, 0, 0);
        return this;
    }

    public TopRightMenu showAsDropDown(View anchor, int xoff, int yoff) {
        if (this.mPopupWindow == null) {
            this.getPopupWindow();
        }
        if (!this.mPopupWindow.isShowing()) {
            this.mPopupWindow.showAsDropDown(anchor, xoff, yoff);
            if (this.dimBackground) {
                this.setBackgroundAlpha(1.0f, this.alpha, 240);
            }
        }
        return this;
    }

    private void setBackgroundAlpha(float from, float to, int duration) {
        final WindowManager.LayoutParams lp = this.mContext.getWindow().getAttributes();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        animator.setDuration((long)duration);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                lp.alpha = ((Float)animation.getAnimatedValue()).floatValue();
                TopRightMenu.this.mContext.getWindow().setAttributes(lp);
            }
        });
        animator.start();
    }

    public void dismiss() {
        if (this.mPopupWindow != null && this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        }
    }

    public static interface OnMenuItemClickListener {
        public void onMenuItemClick(int var1);
    }
}

