/*
 * Decompiled with CFR 0.152.
 */
package prettify.parser;

import android.annotation.SuppressLint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import prettify.parser.Util;

public class CombinePrefixPattern {
    protected int capturedGroupIndex = 0;
    protected boolean needToFoldCase = false;
    protected static final Map<Character, Integer> escapeCharToCodeUnit = new HashMap<Character, Integer>();

    @SuppressLint(value={"WrongConstant"})
    public Pattern combinePrefixPattern(List<Pattern> regexs) throws Exception {
        boolean ignoreCase = false;
        int n = regexs.size();
        for (int i = 0; i < n; ++i) {
            Pattern regex = regexs.get(i);
            if ((regex.flags() & 2) != 0) {
                ignoreCase = true;
                continue;
            }
            if (!Util.test(Pattern.compile("[a-z]", 2), regex.pattern().replaceAll("\\\\[Uu][0-9A-Fa-f]{4}|\\\\[Xx][0-9A-Fa-f]{2}|\\\\[^UuXx]", ""))) continue;
            this.needToFoldCase = true;
            ignoreCase = false;
            break;
        }
        ArrayList<String> rewritten = new ArrayList<String>();
        int n2 = regexs.size();
        for (int i = 0; i < n2; ++i) {
            Pattern regex = regexs.get(i);
            if ((regex.flags() & 8) != 0) {
                throw new Exception(regex.pattern());
            }
            rewritten.add("(?:" + this.allowAnywhereFoldCaseAndRenumberGroups(regex) + ")");
        }
        return ignoreCase ? Pattern.compile(Util.join(rewritten, "|"), 2) : Pattern.compile(Util.join(rewritten, "|"));
    }

    protected static int decodeEscape(String charsetPart) {
        Integer cc0 = charsetPart.codePointAt(0);
        if (cc0 != 92) {
            return cc0;
        }
        char c1 = charsetPart.charAt(1);
        cc0 = escapeCharToCodeUnit.get(Character.valueOf(c1));
        if (cc0 != null) {
            return cc0;
        }
        if ('0' <= c1 && c1 <= '7') {
            return Integer.parseInt(charsetPart.substring(1), 8);
        }
        if (c1 == 'u' || c1 == 'x') {
            return Integer.parseInt(charsetPart.substring(2), 16);
        }
        return charsetPart.codePointAt(1);
    }

    protected static String encodeEscape(int charCode) {
        if (charCode < 32) {
            return (charCode < 16 ? "\\x0" : "\\x") + Integer.toString(charCode, 16);
        }
        String ch = new String(Character.toChars(charCode));
        return charCode == 92 || charCode == 45 || charCode == 93 || charCode == 94 ? "\\" + ch : ch;
    }

    @SuppressLint(value={"WrongConstant"})
    protected static String caseFoldCharset(String charSet) {
        int i;
        String[] charsetParts = Util.match(Pattern.compile("\\\\u[0-9A-Fa-f]{4}|\\\\x[0-9A-Fa-f]{2}|\\\\[0-3][0-7]{0,2}|\\\\[0-7]{1,2}|\\\\[\\s\\S]|-|[^-\\\\]"), charSet.substring(1, charSet.length() - 1), true);
        ArrayList<List<Integer>> ranges = new ArrayList<List<Integer>>();
        boolean inverse = charsetParts[0] != null && charsetParts[0].equals("^");
        ArrayList<String> out = new ArrayList<String>(Arrays.asList("["));
        if (inverse) {
            out.add("^");
        }
        int n = charsetParts.length;
        for (int i2 = inverse ? 1 : 0; i2 < n; ++i2) {
            int end;
            String p = charsetParts[i2];
            if (Util.test(Pattern.compile("\\\\[bdsw]", 2), p)) {
                out.add(p);
                continue;
            }
            int start = CombinePrefixPattern.decodeEscape(p);
            if (i2 + 2 < n && "-".equals(charsetParts[i2 + 1])) {
                end = CombinePrefixPattern.decodeEscape(charsetParts[i2 + 2]);
                i2 += 2;
            } else {
                end = start;
            }
            ranges.add(Arrays.asList(start, end));
            if (end < 65 || start > 122) continue;
            if (end >= 65 && start <= 90) {
                ranges.add(Arrays.asList(Math.max(65, start) | 0x20, Math.min(end, 90) | 0x20));
            }
            if (end < 97 || start > 122) continue;
            ranges.add(Arrays.asList(Math.max(97, start) & 0xFFFFFFDF, Math.min(end, 122) & 0xFFFFFFDF));
        }
        Collections.sort(ranges, new Comparator<List<Integer>>(){

            @Override
            public int compare(List<Integer> a, List<Integer> b) {
                return a.get(0) != b.get(0) ? a.get(0) - b.get(0) : b.get(1) - a.get(1);
            }
        });
        ArrayList<List> consolidatedRanges = new ArrayList<List>();
        List<Integer> lastRange = new ArrayList<Integer>(Arrays.asList(0, 0));
        for (i = 0; i < ranges.size(); ++i) {
            List range = (List)ranges.get(i);
            if (lastRange.get(1) != null && (Integer)range.get(0) <= lastRange.get(1) + 1) {
                lastRange.set(1, Math.max(lastRange.get(1), (Integer)range.get(1)));
                continue;
            }
            lastRange = range;
            consolidatedRanges.add(lastRange);
        }
        for (i = 0; i < consolidatedRanges.size(); ++i) {
            List range = (List)consolidatedRanges.get(i);
            out.add(CombinePrefixPattern.encodeEscape((Integer)range.get(0)));
            if ((Integer)range.get(1) <= (Integer)range.get(0)) continue;
            if ((Integer)range.get(1) + 1 > (Integer)range.get(0)) {
                out.add("-");
            }
            out.add(CombinePrefixPattern.encodeEscape((Integer)range.get(1)));
        }
        out.add("]");
        return Util.join(out);
    }

    protected String allowAnywhereFoldCaseAndRenumberGroups(Pattern regex) {
        int i;
        String p;
        String[] parts = Util.match(Pattern.compile("(?:\\[(?:[^\\x5C\\x5D]|\\\\[\\s\\S])*\\]|\\\\u[A-Fa-f0-9]{4}|\\\\x[A-Fa-f0-9]{2}|\\\\[0-9]+|\\\\[^ux0-9]|\\(\\?[:!=]|[\\(\\)\\^]|[^\\x5B\\x5C\\(\\)\\^]+)"), regex.pattern(), true);
        int n = parts.length;
        HashMap<Integer, Integer> capturedGroups = new HashMap<Integer, Integer>();
        int groupIndex = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            p = parts[i2];
            if (p.equals("(")) {
                ++groupIndex;
                continue;
            }
            if ('\\' != p.charAt(0)) continue;
            try {
                int decimalValue = Math.abs(Integer.parseInt(p.substring(1)));
                if (decimalValue <= groupIndex) {
                    capturedGroups.put(decimalValue, -1);
                    continue;
                }
                parts[i2] = CombinePrefixPattern.encodeEscape(decimalValue);
                continue;
            }
            catch (NumberFormatException decimalValue) {
                // empty catch block
            }
        }
        Iterator i2 = capturedGroups.keySet().iterator();
        while (i2.hasNext()) {
            int i3 = (Integer)i2.next();
            if (-1 != (Integer)capturedGroups.get(i3)) continue;
            capturedGroups.put(i3, ++this.capturedGroupIndex);
        }
        groupIndex = 0;
        for (i = 0; i < n; ++i) {
            p = parts[i];
            if (p.equals("(")) {
                if (capturedGroups.get(++groupIndex) != null) continue;
                parts[i] = "(?:";
                continue;
            }
            if ('\\' != p.charAt(0)) continue;
            try {
                int decimalValue = Math.abs(Integer.parseInt(p.substring(1)));
                if (decimalValue > groupIndex) continue;
                parts[i] = "\\" + capturedGroups.get(decimalValue);
                continue;
            }
            catch (NumberFormatException decimalValue) {
                // empty catch block
            }
        }
        for (i = 0; i < n; ++i) {
            if (!"^".equals(parts[i]) || "^".equals(parts[i + 1])) continue;
            parts[i] = "";
        }
        if ((regex.flags() & 2) != 0 && this.needToFoldCase) {
            for (i = 0; i < n; ++i) {
                char ch0;
                String p2 = parts[i];
                char c = ch0 = p2.length() > 0 ? p2.charAt(0) : (char)'\u0000';
                if (p2.length() >= 2 && ch0 == '[') {
                    parts[i] = CombinePrefixPattern.caseFoldCharset(p2);
                    continue;
                }
                if (ch0 == '\\') continue;
                StringBuffer sb = new StringBuffer();
                Matcher _matcher = Pattern.compile("[a-zA-Z]").matcher(p2);
                while (_matcher.find()) {
                    int cc = _matcher.group(0).codePointAt(0);
                    _matcher.appendReplacement(sb, "");
                    sb.append("[").append(Character.toString((char)(cc & 0xFFFFFFDF))).append(Character.toString((char)(cc | 0x20))).append("]");
                }
                _matcher.appendTail(sb);
                parts[i] = sb.toString();
            }
        }
        return Util.join(parts);
    }

    static {
        escapeCharToCodeUnit.put(Character.valueOf('b'), 8);
        escapeCharToCodeUnit.put(Character.valueOf('t'), 9);
        escapeCharToCodeUnit.put(Character.valueOf('n'), 10);
        escapeCharToCodeUnit.put(Character.valueOf('v'), 11);
        escapeCharToCodeUnit.put(Character.valueOf('f'), 12);
        escapeCharToCodeUnit.put(Character.valueOf('r'), 15);
    }
}

