/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.utils;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.Pair;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDCodeBlockSpan;
import com.yydcdut.markdown.theme.Theme;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static int findNextNewLineChar(CharSequence s, int start) {
        for (int i = start; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            return i;
        }
        return -1;
    }

    public static int findNextNewLineCharCompat(CharSequence s, int start) {
        int position = Utils.findNextNewLineChar(s, start);
        if (position == -1) {
            return s.length();
        }
        return position;
    }

    public static int findBeforeNewLineChar(CharSequence s, int start) {
        for (int i = start - 1; i > 0; --i) {
            if (s.charAt(i) != '\n') continue;
            return i;
        }
        return -1;
    }

    public static <T> void removeSpans(Editable editable, int start, Class<T> clazz) {
        int startPosition = Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1;
        int endPosition = Utils.findNextNewLineCharCompat((CharSequence)editable, start);
        Object[] ts = editable.getSpans(startPosition, endPosition, clazz);
        if (clazz.isAssignableFrom(MDCodeBlockSpan.class)) {
            for (Object t : ts) {
                for (MDCodeBlockSpan mdCodeBlockSpan = (MDCodeBlockSpan)t; mdCodeBlockSpan != null; mdCodeBlockSpan = mdCodeBlockSpan.getNext()) {
                    editable.removeSpan((Object)mdCodeBlockSpan);
                }
            }
        } else {
            for (Object t : ts) {
                editable.removeSpan(t);
            }
        }
    }

    public static void setSpans(Editable editable, List<EditToken> editTokenList) {
        for (EditToken editToken : editTokenList) {
            editable.setSpan(editToken.getSpan(), editToken.getStart(), editToken.getEnd(), editToken.getFlag());
        }
    }

    public static void setCodeSpan(Editable editable, List<EditToken> editTokenList) {
        for (EditToken editToken : editTokenList) {
            Object[] spans;
            for (Object o : spans = editable.getSpans(editToken.getStart(), editToken.getEnd(), Object.class)) {
                if (editToken.getStart() > editable.getSpanStart(o) || editToken.getEnd() < editable.getSpanEnd(o)) continue;
                editable.removeSpan(o);
            }
        }
        Utils.setSpans(editable, editTokenList);
    }

    public static List<EditToken> getMatchedEditTokenList(Editable editable, List<EditToken> allList, int start) {
        ArrayList<EditToken> matchEditTokenList = new ArrayList<EditToken>();
        int startPosition = Utils.findBeforeNewLineChar((CharSequence)editable, start) + 1;
        int endPosition = Utils.findNextNewLineCharCompat((CharSequence)editable, start);
        for (EditToken editToken : allList) {
            if (editToken.getStart() < startPosition || editToken.getEnd() > endPosition) continue;
            matchEditTokenList.add(editToken);
        }
        return matchEditTokenList;
    }

    public static List<Pair<Integer, Integer>> find(@NonNull String text, @NonNull String KEY_CODE) {
        ArrayList<Pair<Integer, Integer>> list = new ArrayList<Pair<Integer, Integer>>();
        String[] lines = text.split("\n");
        int start = -1;
        int end = -1;
        int currentLength = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith(KEY_CODE)) {
                if (start == -1) {
                    start = currentLength;
                } else if (end == -1 && TextUtils.equals((CharSequence)lines[i], (CharSequence)KEY_CODE)) {
                    end = currentLength;
                }
                if (start != -1 && end != -1) {
                    list.add((Pair<Integer, Integer>)new Pair((Object)start, (Object)end));
                    start = -1;
                    end = -1;
                }
            }
            currentLength += lines[i].length() + "\n".length();
        }
        return list;
    }

    public static List<Integer> getNewLineCharPosition(SpannableStringBuilder ssb, int start, int end) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = start; i < end; ++i) {
            if (ssb.charAt(i) != '\n') continue;
            list.add(i);
        }
        return list;
    }

    public static String getPlaceHolder(String matchString) {
        int length = matchString.length();
        StringBuilder placeHolder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            placeHolder.append(" ");
        }
        return placeHolder.toString();
    }

    public static Map<String, Integer> buildColorsMap(Theme theme) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("typ", theme.getTypeColor());
        map.put("kwd", theme.getKeyWordColor());
        map.put("lit", theme.getLiteralColor());
        map.put("com", theme.getCommentColor());
        map.put("str", theme.getStringColor());
        map.put("pun", theme.getPunctuationColor());
        map.put("tag", theme.getTagColor());
        map.put("pln", theme.getPlainTextColor());
        map.put("dec", theme.getDecimalColor());
        map.put("atn", theme.getAttributeNameColor());
        map.put("atv", theme.getAttributeValueColor());
        map.put("opn", theme.getOpnColor());
        map.put("clo", theme.getCloColor());
        map.put("var", theme.getVarColor());
        map.put("fun", theme.getFunColor());
        map.put("nocode", theme.getNocodeColor());
        return map;
    }

    public static StringBuilder standardizeLineEndings(StringBuilder text, String regex, String replacement) {
        Pattern p = Pattern.compile(regex, 8);
        Matcher m = p.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return new StringBuilder(sb);
    }

    public static void standardizeLineEndings(SpannableStringBuilder ssb, String target, String replacement) {
        String string = ssb.toString();
        while (string.indexOf(target) != -1) {
            int start = string.indexOf(target);
            ssb.replace(start, start + target.length(), (CharSequence)replacement);
            string = ssb.toString();
        }
    }
}

