/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.utils;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.view.View;
import com.yydcdut.markdown.callback.OnTodoClickListener;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDCodeBlockSpan;
import com.yydcdut.markdown.span.MDImageSpan;
import com.yydcdut.markdown.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyntaxUtils {
    public static SpannableStringBuilder parseBoldAndItalic(@NonNull String key, @NonNull SpannableStringBuilder ssb, @NonNull Object whatSpan) {
        String text = ssb.toString();
        int keyLength = key.length();
        SpannableStringBuilder tmp = new SpannableStringBuilder();
        String tmpTotal = text;
        while (true) {
            int positionHeader;
            if ((positionHeader = SyntaxUtils.findPosition(key, tmpTotal, ssb, tmp)) == -1) {
                tmp.append((CharSequence)tmpTotal.substring(0, tmpTotal.length()));
                break;
            }
            tmp.append((CharSequence)tmpTotal.substring(0, positionHeader));
            int index = tmp.length();
            tmpTotal = tmpTotal.substring(positionHeader + keyLength, tmpTotal.length());
            int positionFooter = SyntaxUtils.findPosition(key, tmpTotal, ssb, tmp);
            if (positionFooter == -1) {
                tmp.append((CharSequence)key);
                tmp.append((CharSequence)tmpTotal.substring(0, tmpTotal.length()));
                break;
            }
            ssb.delete(tmp.length(), tmp.length() + keyLength);
            tmp.append((CharSequence)tmpTotal.substring(0, positionFooter));
            ssb.setSpan(whatSpan, index, tmp.length(), 33);
            ssb.delete(tmp.length(), tmp.length() + keyLength);
            tmpTotal = tmpTotal.substring(positionFooter + keyLength, tmpTotal.length());
        }
        return ssb;
    }

    private static int findPosition(@NonNull String key, @NonNull String tmpTotal, @NonNull SpannableStringBuilder ssb, @NonNull SpannableStringBuilder tmp) {
        String tmpTmpTotal = tmpTotal;
        int position = tmpTmpTotal.indexOf(key);
        if (position == -1) {
            return -1;
        }
        if (SyntaxUtils.existCodeSyntax(ssb, tmp.length() + position, key.length())) {
            StringBuilder sb = new StringBuilder(tmpTmpTotal.substring(0, position)).append("$$").append(tmpTmpTotal.substring(position + key.length(), tmpTmpTotal.length()));
            return SyntaxUtils.findPosition(key, sb.toString(), ssb, tmp);
        }
        return position;
    }

    public static boolean existCodeSyntax(SpannableStringBuilder ssb, int position, int keyLength) {
        TypefaceSpan[] spans = (TypefaceSpan[])ssb.getSpans(position, position + keyLength, TypefaceSpan.class);
        return spans.length != 0;
    }

    public static boolean existHyperLinkSyntax(SpannableStringBuilder ssb, int position, int keyLength) {
        URLSpan[] spans = (URLSpan[])ssb.getSpans(position, position + keyLength, URLSpan.class);
        return spans.length != 0;
    }

    public static boolean existImageSyntax(SpannableStringBuilder ssb, int position, int keyLength) {
        MDImageSpan[] spans = (MDImageSpan[])ssb.getSpans(position, position + keyLength, MDImageSpan.class);
        return spans.length != 0;
    }

    public static boolean existCodeBlockSpan(@NonNull SpannableStringBuilder ssb, int start, int end) {
        MDCodeBlockSpan[] mdCodeBlockSpans = (MDCodeBlockSpan[])ssb.getSpans(start, end, MDCodeBlockSpan.class);
        return mdCodeBlockSpans != null && mdCodeBlockSpans.length > 0;
    }

    public static List<EditToken> parse(@NonNull Editable editable, @NonNull String pattern, String ignoreText, OnWhatSpanCallback callback) {
        StringBuilder content = new StringBuilder(editable.toString().replace(ignoreText, Utils.getPlaceHolder(ignoreText)));
        return SyntaxUtils.parse(content, pattern, callback);
    }

    @NonNull
    public static List<EditToken> parse(@NonNull Editable editable, @NonNull String pattern, OnWhatSpanCallback callback) {
        StringBuilder content = new StringBuilder((CharSequence)editable);
        return SyntaxUtils.parse(content, pattern, callback);
    }

    public static List<EditToken> parse(@NonNull StringBuilder content, @NonNull String pattern, OnWhatSpanCallback callback) {
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        Matcher m = Pattern.compile(pattern, 8).matcher(content);
        ArrayList<String> matchList = new ArrayList<String>();
        while (m.find()) {
            matchList.add(m.group());
        }
        for (String match : matchList) {
            int index = content.indexOf(match);
            int length = match.length();
            editTokenList.add(new EditToken(callback.whatSpan(), index, index + length));
            content.replace(index, index + length, Utils.getPlaceHolder(match));
        }
        return editTokenList;
    }

    public static boolean isNeedFormat(String key, String string, String beforeString, String afterString) {
        return string.contains(key) || key.equals(beforeString) || key.equals(afterString);
    }

    public static void marginSSBLeft(SpannableStringBuilder ssb, int every) {
        SyntaxUtils.marginSSBLeft(ssb, every, 0, ssb.length());
    }

    public static void marginSSBLeft(SpannableStringBuilder ssb, int every, int start, int end) {
        ssb.setSpan((Object)new LeadingMarginSpan.Standard(every), start, end, 33);
    }

    public static void setTodoOrDoneClick(int endPosition, final SpannableStringBuilder ssb, final OnTodoClickListener onTodoClickListener) {
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        ssb.setSpan((Object)new ImageSpan(bitmap), 0, endPosition, 33);
        ssb.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                if (onTodoClickListener != null) {
                    onTodoClickListener.onTodoClicked(widget, ssb);
                }
            }
        }, 0, "- [ ] ".length(), 33);
    }

    public static interface OnWhatSpanCallback {
        public Object whatSpan();
    }
}

