/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDUnOrderListSpan;
import com.yydcdut.markdown.syntax.Syntax;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.ArrayList;
import java.util.List;

class UnOrderListSyntax
implements Syntax {
    private static final int START_POSITION = 2;
    private int mColor;

    public UnOrderListSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        this.mColor = markdownConfiguration.getUnOrderListColor();
    }

    @Override
    public boolean isMatch(@NonNull CharSequence charSequence) {
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return false;
        }
        String[] lines = charSequence.toString().split("\n");
        int length = lines.length;
        for (int i = 0; i < length; ++i) {
            if (!lines[i].startsWith("* ") && !lines[i].startsWith("+ ") && !lines[i].startsWith("- ")) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public CharSequence format(@NonNull CharSequence charSequence) {
        int i;
        if (!(charSequence instanceof SpannableStringBuilder)) {
            return charSequence;
        }
        SpannableStringBuilder ssb = (SpannableStringBuilder)charSequence;
        String text = charSequence.toString();
        int currentLineIndex = 0;
        String[] lines = text.split("\n");
        ArrayList<NestedUnOrderListBean> list = new ArrayList<NestedUnOrderListBean>(lines.length);
        for (i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith("- [ ] ") || lines[i].startsWith("* [ ] ") || lines[i].startsWith("- [x] ") || lines[i].startsWith("- [X] ") || lines[i].startsWith("* [x] ") || lines[i].startsWith("* [X] ")) {
                list.add(new NestedUnOrderListBean(currentLineIndex, false, lines[i], -1, 0));
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            if (SyntaxUtils.existCodeBlockSpan(ssb, currentLineIndex, currentLineIndex + lines[i].length())) {
                list.add(new NestedUnOrderListBean(currentLineIndex, false, lines[i], -1, 0));
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            if (lines[i].startsWith("* ")) {
                list.add(new NestedUnOrderListBean(currentLineIndex, true, lines[i], 0, 2));
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            if (lines[i].startsWith("+ ")) {
                list.add(new NestedUnOrderListBean(currentLineIndex, true, lines[i], 0, 0));
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            if (lines[i].startsWith("- ")) {
                list.add(new NestedUnOrderListBean(currentLineIndex, true, lines[i], 0, 1));
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            if (!lines[i].startsWith(" ")) {
                list.add(new NestedUnOrderListBean(currentLineIndex, false, lines[i], -1, 0));
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            int nested = this.calculateNested(lines[i]);
            if (nested > 0) {
                if (i - 1 < 0 || i - 1 >= list.size()) {
                    currentLineIndex += (lines[i] + "\n").length();
                    continue;
                }
                int type = this.calculateNestedType(lines[i]);
                NestedUnOrderListBean previousBean = (NestedUnOrderListBean)list.get(i - 1);
                if (previousBean != null && previousBean.isRegular && nested <= previousBean.nested + 1) {
                    list.add(new NestedUnOrderListBean(currentLineIndex, true, lines[i], nested, type));
                } else {
                    list.add(new NestedUnOrderListBean(currentLineIndex, false, lines[i], -1, 0));
                }
            }
            currentLineIndex += (lines[i] + "\n").length();
        }
        for (i = list.size() - 1; i >= 0; --i) {
            NestedUnOrderListBean bean = (NestedUnOrderListBean)list.get(i);
            if (bean == null || !bean.isRegular) continue;
            this.setSSB(bean.nested, bean.start, bean.line, bean.type, ssb);
        }
        return ssb;
    }

    private int calculateNestedType(@NonNull String text) {
        int nested = 0;
        while ((nested + 1) * " ".length() <= text.length()) {
            String sub = text.substring(nested * " ".length(), (nested + 1) * " ".length());
            if (" ".equals(sub)) {
                ++nested;
                continue;
            }
            if ("*".equals(sub)) {
                return 0;
            }
            if ("+".equals(sub)) {
                return 2;
            }
            if ("-".equals(sub)) {
                return 1;
            }
            return 0;
        }
        return nested;
    }

    private int calculateNested(@NonNull String text) {
        int nested = 0;
        while ((nested + 1) * " ".length() <= text.length()) {
            String sub = text.substring(nested * " ".length(), (nested + 1) * " ".length());
            if (" ".equals(sub)) {
                ++nested;
                continue;
            }
            if ("*".equals(sub) || "+".equals(sub) || "-".equals(sub)) {
                return nested;
            }
            return -1;
        }
        return nested;
    }

    private void setSSB(int nested, int start, @NonNull String line, int type, @NonNull SpannableStringBuilder ssb) {
        ssb.delete(start, start + nested * " ".length() + 2);
        ssb.setSpan((Object)new MDUnOrderListSpan(10, this.mColor, nested, type), start, start + line.length() - (nested * " ".length() + 2), 33);
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        return new ArrayList<EditToken>();
    }

    private static class NestedUnOrderListBean {
        final int start;
        final boolean isRegular;
        final String line;
        final int nested;
        final int type;

        public NestedUnOrderListBean(int start, boolean isRegular, @NonNull String line, int nested, int type) {
            this.start = start;
            this.isRegular = isRegular;
            this.line = line;
            this.nested = nested;
            this.type = type;
        }
    }
}

