/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.view.View;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.callback.OnTodoClickCallback;
import com.yydcdut.markdown.callback.OnTodoClickListener;
import com.yydcdut.markdown.span.MDTodoDoneSpan;
import com.yydcdut.markdown.span.MDTodoSpan;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.SyntaxUtils;

class TodoDoneSyntax
extends TextSyntaxAdapter
implements OnTodoClickListener {
    private int mDoneColor;
    private int mTodoColor;
    private OnTodoClickCallback mOnTodoClickCallback;

    public TodoDoneSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mDoneColor = markdownConfiguration.getTodoDoneColor();
        this.mTodoColor = markdownConfiguration.getTodoColor();
        this.mOnTodoClickCallback = markdownConfiguration.getOnTodoClickCallback();
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return text.startsWith("- [x] ") || text.startsWith("- [X] ") || text.startsWith("* [x] ") || text.startsWith("* [X] ");
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        return false;
    }

    @Override
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        SyntaxUtils.setTodoOrDoneClick("- [x] ".length(), ssb, this);
        ssb.setSpan((Object)new MDTodoDoneSpan(this.mDoneColor), 0, ssb.length(), 33);
        return ssb;
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
    }

    @Override
    public void onTodoClicked(View view, SpannableStringBuilder ssb) {
        if (this.mOnTodoClickCallback == null) {
            return;
        }
        CharSequence charSequence = this.mOnTodoClickCallback.onTodoClicked(view, ssb.toString().replace("\n", ""));
        if (!(charSequence instanceof SpannableString)) {
            return;
        }
        SpannableString sb = (SpannableString)charSequence;
        MDTodoSpan[] ssbArray = (MDTodoSpan[])ssb.getSpans(0, ssb.length(), MDTodoSpan.class);
        if (ssbArray == null || ssbArray.length != 1) {
            return;
        }
        if (ssbArray[0] instanceof MDTodoDoneSpan) {
            MDTodoDoneSpan mdTodoDoneSpan = (MDTodoDoneSpan)ssbArray[0];
            int start = sb.getSpanStart((Object)mdTodoDoneSpan);
            int end = sb.getSpanEnd((Object)mdTodoDoneSpan);
            if (start < 0 || end < 0) {
                return;
            }
            sb.removeSpan((Object)mdTodoDoneSpan);
            MDTodoSpan mdTodoSpan = new MDTodoSpan(this.mTodoColor);
            sb.setSpan((Object)mdTodoSpan, start, end, 33);
            ssb.removeSpan((Object)mdTodoDoneSpan);
            ssb.setSpan((Object)mdTodoSpan, 0, ssb.length(), 33);
        } else if (ssbArray[0] instanceof MDTodoSpan) {
            MDTodoSpan mdTodoSpan = ssbArray[0];
            int start = sb.getSpanStart((Object)mdTodoSpan);
            int end = sb.getSpanEnd((Object)mdTodoSpan);
            if (start < 0 || end < 0) {
                return;
            }
            sb.removeSpan((Object)mdTodoSpan);
            MDTodoDoneSpan mdTodoDoneSpan = new MDTodoDoneSpan(this.mDoneColor);
            sb.setSpan((Object)mdTodoDoneSpan, start, end, 33);
            ssb.removeSpan((Object)mdTodoSpan);
            ssb.setSpan((Object)mdTodoDoneSpan, 0, ssb.length(), 33);
        }
    }
}

