/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDCodeBlockSpan;
import com.yydcdut.markdown.syntax.Syntax;
import java.util.ArrayList;
import java.util.List;

abstract class TextSyntaxAdapter
implements Syntax {
    public TextSyntaxAdapter(@NonNull MarkdownConfiguration markdownConfiguration) {
    }

    @Override
    public boolean isMatch(@NonNull CharSequence charSequence) {
        if (!(charSequence instanceof SpannableStringBuilder)) {
            return false;
        }
        SpannableStringBuilder ssb = (SpannableStringBuilder)charSequence;
        if (((MDCodeBlockSpan[])ssb.getSpans(0, ssb.length(), MDCodeBlockSpan.class)).length > 0) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return false;
        }
        return this.isMatch(charSequence.toString());
    }

    @Override
    @NonNull
    public CharSequence format(@NonNull CharSequence charSequence) {
        if (!(charSequence instanceof SpannableStringBuilder)) {
            return charSequence;
        }
        SpannableStringBuilder ssb = (SpannableStringBuilder)charSequence;
        boolean isHandledBackSlash = this.encode(ssb);
        ssb = this.format(ssb);
        if (isHandledBackSlash) {
            this.decode(ssb);
        }
        return ssb;
    }

    protected static boolean replace(SpannableStringBuilder ssb, String key, String replace) {
        String text;
        int index;
        boolean isHandledBackSlash = false;
        while ((index = (text = ssb.toString()).indexOf(key)) != -1) {
            isHandledBackSlash = true;
            ssb.replace(index, index + key.length(), (CharSequence)replace);
        }
        return isHandledBackSlash;
    }

    abstract boolean isMatch(@NonNull String var1);

    @NonNull
    abstract boolean encode(@NonNull SpannableStringBuilder var1);

    @NonNull
    abstract SpannableStringBuilder format(@NonNull SpannableStringBuilder var1);

    @NonNull
    abstract void decode(@NonNull SpannableStringBuilder var1);

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        return new ArrayList<EditToken>();
    }
}

