/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.chain.ISpecialChain;
import com.yydcdut.markdown.chain.MultiSyntaxChain;
import com.yydcdut.markdown.chain.SyntaxChain;
import com.yydcdut.markdown.chain.SyntaxDoElseChain;
import com.yydcdut.markdown.chain.SyntaxMultiChains;
import com.yydcdut.markdown.syntax.Syntax;
import com.yydcdut.markdown.syntax.SyntaxFactory;
import com.yydcdut.markdown.syntax.text.BackslashSyntax;
import com.yydcdut.markdown.syntax.text.BlockQuotesSyntax;
import com.yydcdut.markdown.syntax.text.BoldSyntax;
import com.yydcdut.markdown.syntax.text.CenterAlignSyntax;
import com.yydcdut.markdown.syntax.text.CodeBlockSyntax;
import com.yydcdut.markdown.syntax.text.CodeSyntax;
import com.yydcdut.markdown.syntax.text.FootnoteSyntax;
import com.yydcdut.markdown.syntax.text.HeaderSyntax;
import com.yydcdut.markdown.syntax.text.HorizontalRulesSyntax;
import com.yydcdut.markdown.syntax.text.HyperLinkSyntax;
import com.yydcdut.markdown.syntax.text.ImageSyntax;
import com.yydcdut.markdown.syntax.text.ItalicSyntax;
import com.yydcdut.markdown.syntax.text.OrderListSyntax;
import com.yydcdut.markdown.syntax.text.StrikeThroughSyntax;
import com.yydcdut.markdown.syntax.text.TodoDoneSyntax;
import com.yydcdut.markdown.syntax.text.TodoSyntax;
import com.yydcdut.markdown.syntax.text.UnOrderListSyntax;
import com.yydcdut.markdown.utils.Utils;

public class TextFactory
implements SyntaxFactory {
    private static final String NEWLINE = "\n";
    private MarkdownConfiguration mMarkdownConfiguration;
    private ISpecialChain mLineChain;
    private ISpecialChain mTotalChain;

    private TextFactory() {
    }

    public static SyntaxFactory create() {
        return new TextFactory();
    }

    @Override
    public Syntax getHorizontalRulesSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new HorizontalRulesSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getBlockQuotesSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new BlockQuotesSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getTodoSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new TodoSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getTodoDoneSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new TodoDoneSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getOrderListSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new OrderListSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getUnOrderListSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new UnOrderListSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getCenterAlignSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new CenterAlignSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getHeaderSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new HeaderSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getBoldSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new BoldSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getItalicSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new ItalicSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getCodeSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new CodeSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getStrikeThroughSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new StrikeThroughSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getFootnoteSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new FootnoteSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getImageSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new ImageSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getHyperLinkSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new HyperLinkSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getCodeBlockSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new CodeBlockSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getBackslashSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new BackslashSyntax(markdownConfiguration);
    }

    private void init(@NonNull MarkdownConfiguration markdownConfiguration) {
        this.mMarkdownConfiguration = markdownConfiguration;
        this.mTotalChain = new MultiSyntaxChain(this.getCodeBlockSyntax(markdownConfiguration), this.getUnOrderListSyntax(markdownConfiguration), this.getOrderListSyntax(markdownConfiguration));
        this.mLineChain = new SyntaxChain(this.getHorizontalRulesSyntax(markdownConfiguration));
        SyntaxDoElseChain blockQuitesChain = new SyntaxDoElseChain(this.getBlockQuotesSyntax(markdownConfiguration));
        SyntaxDoElseChain todoChain = new SyntaxDoElseChain(this.getTodoSyntax(markdownConfiguration));
        SyntaxDoElseChain todoDoneChain = new SyntaxDoElseChain(this.getTodoDoneSyntax(markdownConfiguration));
        SyntaxMultiChains centerAlignChain = new SyntaxMultiChains(this.getCenterAlignSyntax(markdownConfiguration));
        SyntaxMultiChains headerChain = new SyntaxMultiChains(this.getHeaderSyntax(markdownConfiguration));
        MultiSyntaxChain multiChain = new MultiSyntaxChain(this.getImageSyntax(markdownConfiguration), this.getHyperLinkSyntax(markdownConfiguration), this.getCodeSyntax(markdownConfiguration), this.getBoldSyntax(markdownConfiguration), this.getItalicSyntax(markdownConfiguration), this.getStrikeThroughSyntax(markdownConfiguration), this.getFootnoteSyntax(markdownConfiguration));
        SyntaxChain backslashChain = new SyntaxChain(this.getBackslashSyntax(markdownConfiguration));
        this.mLineChain.setNextHandleSyntax(blockQuitesChain);
        blockQuitesChain.setNextHandleSyntax(todoChain);
        blockQuitesChain.addNextHandleSyntax(multiChain);
        todoChain.setNextHandleSyntax(todoDoneChain);
        todoChain.addNextHandleSyntax(multiChain);
        todoDoneChain.setNextHandleSyntax(centerAlignChain);
        todoDoneChain.addNextHandleSyntax(multiChain);
        centerAlignChain.addNextHandleSyntax(headerChain);
        centerAlignChain.addNextHandleSyntax(multiChain);
        multiChain.setNextHandleSyntax(backslashChain);
    }

    @Override
    @NonNull
    public CharSequence parse(@NonNull CharSequence charSequence, @NonNull MarkdownConfiguration markdownConfiguration) {
        if (markdownConfiguration == null) {
            return charSequence;
        }
        if (this.mTotalChain == null || this.mLineChain == null || this.mMarkdownConfiguration == null || this.mMarkdownConfiguration != markdownConfiguration) {
            this.init(markdownConfiguration);
        }
        CharSequence standardLines = this.standardizeLineEndings(charSequence);
        SpannableStringBuilder ssb = new SpannableStringBuilder(standardLines);
        ssb = this.parseTotal(this.mTotalChain, ssb);
        ssb = this.parseByLine(this.mLineChain, ssb);
        return ssb;
    }

    private SpannableStringBuilder parseTotal(ISpecialChain totalChain, SpannableStringBuilder ssb) {
        totalChain.handleSyntax((CharSequence)ssb);
        return ssb;
    }

    private SpannableStringBuilder parseByLine(ISpecialChain lineChain, SpannableStringBuilder content) {
        String text = content.toString();
        String[] lines = text.split(NEWLINE);
        SpannableStringBuilder[] ssbLines = new SpannableStringBuilder[lines.length];
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        int index = 0;
        for (int i = 0; i < lines.length; ++i) {
            ssbLines[i] = (SpannableStringBuilder)content.subSequence(index, index + lines[i].length());
            lineChain.handleSyntax((CharSequence)ssbLines[i]);
            index += lines[i].length();
            if (i < lines.length - 1) {
                ssbLines[i].append((CharSequence)NEWLINE);
                index += NEWLINE.length();
            }
            ssb.append((CharSequence)ssbLines[i]);
        }
        return ssb;
    }

    private CharSequence standardizeLineEndings(CharSequence charSequence) {
        if (charSequence instanceof String || charSequence instanceof StringBuilder || charSequence instanceof StringBuffer) {
            return Utils.standardizeLineEndings(Utils.standardizeLineEndings(new StringBuilder(charSequence), "\\r\\n", NEWLINE), "\\r", NEWLINE).toString();
        }
        if (charSequence instanceof Spannable) {
            SpannableStringBuilder ssb = new SpannableStringBuilder(charSequence);
            Utils.standardizeLineEndings(ssb, "\r\n", NEWLINE);
            Utils.standardizeLineEndings(ssb, "\r", NEWLINE);
            return ssb;
        }
        return charSequence;
    }
}

