/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.StrikethroughSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.CharacterProtector;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.regex.Pattern;

class StrikeThroughSyntax
extends TextSyntaxAdapter {
    private static final String PATTERN = ".*[~]{2}.*[~]{2}.*";

    public StrikeThroughSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return text.contains("~~") ? Pattern.compile(PATTERN).matcher(text).matches() : false;
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        return StrikeThroughSyntax.replace(ssb, "\\~", CharacterProtector.getKeyEncode());
    }

    @Override
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        return SyntaxUtils.parseBoldAndItalic("~~", ssb, new StrikethroughSpan());
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
        StrikeThroughSyntax.replace(ssb, CharacterProtector.getKeyEncode(), "\\~");
    }
}

