/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDOrderListSpan;
import com.yydcdut.markdown.syntax.Syntax;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.ArrayList;
import java.util.List;

class OrderListSyntax
implements Syntax {
    public OrderListSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
    }

    @Override
    public boolean isMatch(@NonNull CharSequence charSequence) {
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return false;
        }
        String[] lines = charSequence.toString().split("\n");
        int length = lines.length;
        for (int i = 0; i < length; ++i) {
            if (!this.checkLegal(lines[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public CharSequence format(@NonNull CharSequence charSequence) {
        int i;
        if (!(charSequence instanceof SpannableStringBuilder)) {
            return charSequence;
        }
        SpannableStringBuilder ssb = (SpannableStringBuilder)charSequence;
        int currentLineIndex = 0;
        String[] lines = charSequence.toString().split("\n");
        ArrayList<NestedOrderListBean> list = new ArrayList<NestedOrderListBean>(lines.length);
        for (i = 0; i < lines.length; ++i) {
            int nested = this.calculateNested(lines[i]);
            if (nested < 0) {
                list.add(new NestedOrderListBean(currentLineIndex, false, lines[i], -1, -1, -1));
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            if (SyntaxUtils.existCodeBlockSpan(ssb, currentLineIndex, currentLineIndex + lines[i].length())) {
                list.add(new NestedOrderListBean(currentLineIndex, false, lines[i], -1, -1, -1));
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            int number = this.calculateNumber(lines[i], nested);
            if (i - 1 < 0 || i - 1 >= list.size()) {
                if (nested == 0) {
                    list.add(new NestedOrderListBean(currentLineIndex, true, lines[i], 0, 1, number));
                } else {
                    list.add(new NestedOrderListBean(currentLineIndex, false, lines[i], -1, -1, -1));
                }
                currentLineIndex += (lines[i] + "\n").length();
                continue;
            }
            NestedOrderListBean previousBean = (NestedOrderListBean)list.get(i - 1);
            if (previousBean != null && previousBean.isRegular && nested <= previousBean.nested + 1) {
                if (nested == previousBean.nested) {
                    list.add(new NestedOrderListBean(currentLineIndex, true, lines[i], nested, previousBean.number + 1, number));
                } else if (nested == previousBean.nested + 1) {
                    list.add(new NestedOrderListBean(currentLineIndex, true, lines[i], nested, 1, number));
                } else {
                    NestedOrderListBean bean;
                    for (int j = i - 2; j >= 0; --j) {
                        NestedOrderListBean previousSameNestedBean = (NestedOrderListBean)list.get(j);
                        if (previousSameNestedBean != null && previousSameNestedBean.isRegular && previousSameNestedBean.nested == nested) {
                            list.add(new NestedOrderListBean(currentLineIndex, true, lines[i], nested, previousSameNestedBean.number + 1, number));
                            break;
                        }
                        if (previousSameNestedBean != null && previousSameNestedBean.isRegular) continue;
                        list.add(new NestedOrderListBean(currentLineIndex, false, lines[i], -1, -1, -1));
                        break;
                    }
                    if ((bean = (NestedOrderListBean)list.get(i)) == null) {
                        list.add(new NestedOrderListBean(currentLineIndex, false, lines[i], -1, -1, -1));
                    }
                }
            } else if (previousBean != null && !previousBean.isRegular && nested == 0) {
                list.add(new NestedOrderListBean(currentLineIndex, true, lines[i], nested, 1, number));
            } else {
                list.add(new NestedOrderListBean(currentLineIndex, false, lines[i], -1, -1, -1));
            }
            currentLineIndex += (lines[i] + "\n").length();
        }
        for (i = list.size() - 1; i >= 0; --i) {
            NestedOrderListBean bean = (NestedOrderListBean)list.get(i);
            if (bean == null || !bean.isRegular) continue;
            this.setSSB(bean.nested, bean.start, bean.line, ssb, bean.number, bean.originalNumber);
        }
        return ssb;
    }

    private boolean checkLegal(@NonNull String text) {
        if (text.length() < 3) {
            return false;
        }
        if (Character.isDigit(text.charAt(0))) {
            int dotPosition = 1;
            int length = text.length();
            for (int i = 1; i < length; ++i) {
                if (Character.isDigit(text.charAt(i))) continue;
                dotPosition = i;
                break;
            }
            return text.charAt(dotPosition) == '.' && text.charAt(dotPosition + 1) == ' ';
        }
        return false;
    }

    private int calculateNested(@NonNull String text) {
        if (text.length() < 2) {
            return -1;
        }
        int nested = 0;
        while ((nested + 1) * " ".length() <= text.length()) {
            String sub = text.substring(nested * " ".length(), (nested + 1) * " ".length());
            if (" ".equals(sub)) {
                ++nested;
                continue;
            }
            if (this.checkLegal(text.substring(nested * " ".length(), text.length()))) {
                return nested;
            }
            return -1;
        }
        return nested;
    }

    private int calculateNumber(@NonNull String text, int nested) {
        int number;
        if (text.length() < 3) {
            return -1;
        }
        String s = text.substring(nested * " ".length(), text.length());
        if (TextUtils.isDigitsOnly((CharSequence)s.substring(0, 1))) {
            number = Integer.parseInt(s.substring(0, 1));
            for (int i = 1; i < s.length(); ++i) {
                if (!TextUtils.isDigitsOnly((CharSequence)s.substring(i, i + 1))) {
                    return number;
                }
                number = number * 10 + Integer.parseInt(s.substring(i, i + 1));
            }
        } else {
            return -1;
        }
        return number;
    }

    private void setSSB(int nested, int start, @NonNull String line, @NonNull SpannableStringBuilder ssb, int number, int originalNumber) {
        ssb.delete(start, start + nested * " ".length() + String.valueOf(originalNumber).length());
        ssb.insert(start, (CharSequence)String.valueOf(number));
        ssb.setSpan((Object)new MDOrderListSpan(30, nested, number), start, start + line.length() - (nested * " ".length() + String.valueOf(originalNumber).length()), 33);
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        return new ArrayList<EditToken>();
    }

    private static class NestedOrderListBean {
        final int start;
        final boolean isRegular;
        final String line;
        final int nested;
        final int number;
        final int originalNumber;

        public NestedOrderListBean(int start, boolean isRegular, @NonNull String line, int nested, int number, int originalNumber) {
            this.start = start;
            this.isRegular = isRegular;
            this.line = line;
            this.nested = nested;
            this.number = number;
            this.originalNumber = originalNumber;
        }
    }
}

