/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.CharacterProtector;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.regex.Pattern;

class ItalicSyntax
extends TextSyntaxAdapter {
    private static final String PATTERN_ASTERISK = ".*[\\*]{1}.*[\\*]{1}.*";
    private static final String PATTERN_UNDERLINE = ".*[_]{1}.*[_]{1}.*";
    private boolean isContainsAsterisk;
    private boolean isContainsUnderline;

    public ItalicSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
    }

    @Override
    boolean isMatch(@NonNull String text) {
        Pattern pattern = Pattern.compile(PATTERN_ASTERISK);
        this.isContainsAsterisk = pattern.matcher(text).matches();
        pattern = Pattern.compile(PATTERN_UNDERLINE);
        this.isContainsUnderline = pattern.matcher(text).matches();
        return this.isContainsAsterisk | this.isContainsUnderline;
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        boolean isHandledBackSlash = false;
        if (this.isContainsAsterisk) {
            isHandledBackSlash |= ItalicSyntax.replace(ssb, "\\*", CharacterProtector.getKeyEncode());
        }
        if (this.isContainsUnderline) {
            isHandledBackSlash |= ItalicSyntax.replace(ssb, "\\_", CharacterProtector.getKeyEncode1());
        }
        return isHandledBackSlash;
    }

    @Override
    @NonNull
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        if (this.isContainsAsterisk) {
            ssb = SyntaxUtils.parseBoldAndItalic("*", ssb, new StyleSpan(2));
        }
        if (this.isContainsUnderline) {
            ssb = SyntaxUtils.parseBoldAndItalic("_", ssb, new StyleSpan(2));
        }
        return ssb;
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
        if (this.isContainsAsterisk) {
            ItalicSyntax.replace(ssb, CharacterProtector.getKeyEncode(), "\\*");
        }
        if (this.isContainsUnderline) {
            ItalicSyntax.replace(ssb, CharacterProtector.getKeyEncode1(), "\\_");
        }
    }
}

