/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.callback.OnLinkClickCallback;
import com.yydcdut.markdown.span.MDURLSpan;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.CharacterProtector;
import java.util.regex.Pattern;

class HyperLinkSyntax
extends TextSyntaxAdapter {
    private static final String PATTERN = ".*[\\[]{1}.*[\\](]{1}.*[)]{1}.*";
    private int mColor;
    private boolean isUnderLine;
    private OnLinkClickCallback mOnLinkClickCallback;

    public HyperLinkSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getLinkFontColor();
        this.isUnderLine = markdownConfiguration.isShowLinkUnderline();
        this.mOnLinkClickCallback = markdownConfiguration.getOnLinkClickCallback();
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return HyperLinkSyntax.contains(text) ? Pattern.compile(PATTERN).matcher(text).matches() : false;
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        boolean isHandledBackSlash = false;
        isHandledBackSlash |= HyperLinkSyntax.replace(ssb, "\\[", CharacterProtector.getKeyEncode());
        isHandledBackSlash |= HyperLinkSyntax.replace(ssb, "\\]", CharacterProtector.getKeyEncode1());
        return isHandledBackSlash |= HyperLinkSyntax.replace(ssb, "\\)", CharacterProtector.getKeyEncode3());
    }

    @Override
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        return this.parse(ssb);
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
        HyperLinkSyntax.replace(ssb, CharacterProtector.getKeyEncode(), "\\[");
        HyperLinkSyntax.replace(ssb, CharacterProtector.getKeyEncode1(), "\\]");
        HyperLinkSyntax.replace(ssb, CharacterProtector.getKeyEncode3(), "\\)");
    }

    private static boolean contains(String text) {
        if (text.length() < 4 || TextUtils.equals((CharSequence)text, (CharSequence)"[]()")) {
            return true;
        }
        char[] array = text.toCharArray();
        int length = array.length;
        char[] findArray = new char[]{'[', ']', '(', ')'};
        int findPosition = 0;
        for (int i = 0; i < length; ++i) {
            if (array[i] != findArray[findPosition]) continue;
            findPosition = findPosition == 1 ? (array[++i] != findArray[++findPosition] ? --findPosition : ++findPosition) : ++findPosition;
            if (findPosition != findArray.length - 1) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private SpannableStringBuilder parse(@NonNull SpannableStringBuilder ssb) {
        String text = ssb.toString();
        SpannableStringBuilder tmp = new SpannableStringBuilder();
        String tmpTotal = text;
        while (true) {
            int position4Key0 = tmpTotal.indexOf("[");
            int position4Key1 = tmpTotal.indexOf("](");
            int position4Key2 = tmpTotal.indexOf(")");
            if (position4Key0 == -1 || position4Key1 == -1 || position4Key2 == -1) break;
            if (position4Key0 < position4Key1 && position4Key1 < position4Key2) {
                int tmpCenter = tmpTotal.indexOf("](");
                String tmpLeft = tmpTotal.substring(0, tmpCenter);
                int positionHeader = tmpLeft.lastIndexOf("[");
                tmp.append((CharSequence)tmpTotal.substring(0, positionHeader));
                int index = tmp.length();
                tmpTotal = tmpTotal.substring(positionHeader + "[".length(), tmpTotal.length());
                int positionCenter = tmpTotal.indexOf("](");
                ssb.delete(tmp.length(), tmp.length() + "[".length());
                tmp.append((CharSequence)tmpTotal.substring(0, positionCenter));
                tmpTotal = tmpTotal.substring(positionCenter + "](".length(), tmpTotal.length());
                int positionFooter = tmpTotal.indexOf(")");
                String link = tmpTotal.substring(0, positionFooter);
                ssb.setSpan((Object)new MDURLSpan(link, this.mColor, this.isUnderLine, this.mOnLinkClickCallback), index, tmp.length(), 33);
                ssb.delete(tmp.length(), tmp.length() + "](".length() + link.length() + ")".length());
                tmpTotal = tmpTotal.substring(positionFooter + ")".length(), tmpTotal.length());
                continue;
            }
            if (position4Key0 < position4Key1 && position4Key0 < position4Key2 && position4Key2 < position4Key1) {
                tmpTotal = HyperLinkSyntax.replaceFirstOne(tmpTotal, ")", " ");
                continue;
            }
            if (position4Key1 < position4Key0 && position4Key1 < position4Key2) {
                tmp.append((CharSequence)tmpTotal.substring(0, position4Key1 + "](".length()));
                tmpTotal = tmpTotal.substring(position4Key1 + "](".length(), tmpTotal.length());
                continue;
            }
            if (position4Key2 >= position4Key0 || position4Key2 >= position4Key1) continue;
            tmp.append((CharSequence)tmpTotal.substring(0, position4Key2 + ")".length()));
            tmpTotal = tmpTotal.substring(position4Key2 + ")".length(), tmpTotal.length());
        }
        return ssb;
    }

    @NonNull
    private static String replaceFirstOne(@NonNull String content, @NonNull String target, @NonNull String replacement) {
        int over;
        int matchStart = content.indexOf(target, 0);
        if (matchStart == -1) {
            return content;
        }
        int targetLength = target.length();
        if (targetLength == 0) {
            int resultLength = content.length() + (content.length() + 1) * replacement.length();
            StringBuilder result = new StringBuilder(resultLength);
            result.append(replacement);
            for (int i = 0; i != content.length(); ++i) {
                result.append(content.charAt(i));
                result.append(replacement);
            }
            return result.toString();
        }
        StringBuilder result = new StringBuilder(content.length());
        for (int i = 0; i < matchStart; ++i) {
            result.append(content.charAt(i));
        }
        result.append(replacement);
        for (int i = over = matchStart + targetLength; i < content.length(); ++i) {
            result.append(content.charAt(i));
        }
        return result.toString();
    }
}

