/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.span.MDHorizontalRulesSpan;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;

class HorizontalRulesSyntax
extends TextSyntaxAdapter {
    private int mColor;
    private int mHeight;

    public HorizontalRulesSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getHorizontalRulesColor();
        this.mHeight = markdownConfiguration.getHorizontalRulesHeight();
    }

    @Override
    boolean isMatch(@NonNull String text) {
        if (text.startsWith("***") && HorizontalRulesSyntax.check(text, '*')) {
            return true;
        }
        return text.startsWith("---") && HorizontalRulesSyntax.check(text, '-');
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        return false;
    }

    @Override
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        ssb.replace(0, ssb.length(), (CharSequence)" ");
        ssb.setSpan((Object)new MDHorizontalRulesSpan(this.mColor, this.mHeight), 0, ssb.length(), 33);
        return ssb;
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
    }

    private static boolean check(@NonNull String text, char key) {
        char[] chars = text.toCharArray();
        boolean bool = true;
        for (int i = 0; i < chars.length && (bool &= chars[i] == key); ++i) {
        }
        return bool;
    }
}

