/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.RelativeSizeSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;

class HeaderSyntax
extends TextSyntaxAdapter {
    private float mHeader1RelativeSize;
    private float mHeader2RelativeSize;
    private float mHeader3RelativeSize;
    private float mHeader4RelativeSize;
    private float mHeader5RelativeSize;
    private float mHeader6RelativeSize;

    public HeaderSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mHeader1RelativeSize = markdownConfiguration.getHeader1RelativeSize();
        this.mHeader2RelativeSize = markdownConfiguration.getHeader2RelativeSize();
        this.mHeader3RelativeSize = markdownConfiguration.getHeader3RelativeSize();
        this.mHeader4RelativeSize = markdownConfiguration.getHeader4RelativeSize();
        this.mHeader5RelativeSize = markdownConfiguration.getHeader5RelativeSize();
        this.mHeader6RelativeSize = markdownConfiguration.getHeader6RelativeSize();
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return text.startsWith("# ") || text.startsWith("## ") || text.startsWith("### ") || text.startsWith("#### ") || text.startsWith("##### ") || text.startsWith("###### ");
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        return false;
    }

    @Override
    @NonNull
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        String text = ssb.toString();
        if (text.startsWith("###### ")) {
            ssb.delete(0, "###### ".length());
            ssb.setSpan((Object)new RelativeSizeSpan(this.mHeader6RelativeSize), 0, ssb.length(), 33);
        } else if (text.startsWith("##### ")) {
            ssb.delete(0, "##### ".length());
            ssb.setSpan((Object)new RelativeSizeSpan(this.mHeader5RelativeSize), 0, ssb.length(), 33);
        } else if (text.startsWith("#### ")) {
            ssb.delete(0, "#### ".length());
            ssb.setSpan((Object)new RelativeSizeSpan(this.mHeader4RelativeSize), 0, ssb.length(), 33);
        } else if (text.startsWith("### ")) {
            ssb.delete(0, "### ".length());
            ssb.setSpan((Object)new RelativeSizeSpan(this.mHeader3RelativeSize), 0, ssb.length(), 33);
        } else if (text.startsWith("## ")) {
            ssb.delete(0, "## ".length());
            ssb.setSpan((Object)new RelativeSizeSpan(this.mHeader2RelativeSize), 0, ssb.length(), 33);
        } else if (text.startsWith("# ")) {
            ssb.delete(0, "# ".length());
            ssb.setSpan((Object)new RelativeSizeSpan(this.mHeader1RelativeSize), 0, ssb.length(), 33);
        }
        return ssb;
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
    }
}

