/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.SuperscriptSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.CharacterProtector;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.regex.Pattern;

class FootnoteSyntax
extends TextSyntaxAdapter {
    private static final String PATTERN = ".*[\\[\\^].*[]].*";

    public FootnoteSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return FootnoteSyntax.contains(text) ? Pattern.compile(PATTERN).matcher(text).matches() : false;
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        boolean isHandledBackSlash = false;
        isHandledBackSlash |= FootnoteSyntax.replace(ssb, "\\[", CharacterProtector.getKeyEncode());
        return isHandledBackSlash |= FootnoteSyntax.replace(ssb, "\\]", CharacterProtector.getKeyEncode2());
    }

    @Override
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        String text = ssb.toString();
        return FootnoteSyntax.parse(text, ssb);
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
        FootnoteSyntax.replace(ssb, CharacterProtector.getKeyEncode(), "\\[");
        FootnoteSyntax.replace(ssb, CharacterProtector.getKeyEncode2(), "\\]");
    }

    private static boolean contains(String text) {
        if (text.length() < 3 || TextUtils.equals((CharSequence)text, (CharSequence)"[^]")) {
            return true;
        }
        char[] array = text.toCharArray();
        int length = array.length;
        char[] findArray = new char[]{'[', '^', ']'};
        int findPosition = 0;
        for (int i = 0; i < length; ++i) {
            if (array[i] != findArray[findPosition]) continue;
            findPosition = findPosition == 0 ? (array[++i] != findArray[++findPosition] ? --findPosition : ++findPosition) : ++findPosition;
            if (findPosition != findArray.length - 1) continue;
            return true;
        }
        return false;
    }

    private static SpannableStringBuilder parse(@NonNull String text, @NonNull SpannableStringBuilder ssb) {
        SpannableStringBuilder tmp = new SpannableStringBuilder();
        String tmpTotal = text;
        while (true) {
            int positionHeader;
            if ((positionHeader = FootnoteSyntax.findBeginPosition(tmpTotal, ssb, tmp)) == -1) {
                tmp.append((CharSequence)tmpTotal.substring(0, tmpTotal.length()));
                break;
            }
            tmp.append((CharSequence)tmpTotal.substring(0, positionHeader));
            int index = tmp.length();
            tmpTotal = tmpTotal.substring(positionHeader + "[^".length(), tmpTotal.length());
            int positionFooter = FootnoteSyntax.findEndPosition(tmpTotal, ssb, tmp);
            if (positionFooter == -1) {
                tmp.append((CharSequence)"[^");
                tmp.append((CharSequence)tmpTotal.substring(0, tmpTotal.length()));
                break;
            }
            ssb.delete(tmp.length(), tmp.length() + "[^".length());
            tmp.append((CharSequence)tmpTotal.substring(0, positionFooter));
            ssb.setSpan((Object)new SuperscriptSpan(), index, tmp.length(), 33);
            ssb.delete(tmp.length(), tmp.length() + "]".length());
            tmpTotal = tmpTotal.substring(positionFooter + "[^".length(), tmpTotal.length());
        }
        return ssb;
    }

    private static int findBeginPosition(@NonNull String tmpTotal, @NonNull SpannableStringBuilder ssb, @NonNull SpannableStringBuilder tmp) {
        String tmpTmpTotal = tmpTotal;
        int position = tmpTmpTotal.indexOf("[^");
        if (position == -1) {
            return -1;
        }
        if (SyntaxUtils.existCodeSyntax(ssb, tmp.length() + position, "[^".length())) {
            StringBuilder sb = new StringBuilder(tmpTmpTotal.substring(0, position)).append("$$").append(tmpTmpTotal.substring(position + "[^".length(), tmpTmpTotal.length()));
            return FootnoteSyntax.findBeginPosition(sb.toString(), ssb, tmp);
        }
        return position;
    }

    private static int findEndPosition(@NonNull String tmpTotal, @NonNull SpannableStringBuilder ssb, @NonNull SpannableStringBuilder tmp) {
        String tmpTmpTotal = tmpTotal;
        int position = tmpTmpTotal.indexOf("]");
        if (position == -1) {
            return -1;
        }
        if (SyntaxUtils.existCodeSyntax(ssb, tmp.length() + position, "]".length())) {
            StringBuilder sb = new StringBuilder(tmpTmpTotal.substring(0, position)).append("$").append(tmpTmpTotal.substring(position + "]".length(), tmpTmpTotal.length()));
            return FootnoteSyntax.findBeginPosition(sb.toString(), ssb, tmp);
        }
        return position;
    }
}

