/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.TypefaceSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.span.MDCodeSpan;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.CharacterProtector;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.regex.Pattern;

class CodeSyntax
extends TextSyntaxAdapter {
    private static final String PATTERN = ".*[`]{1}.*[`]{1}.*";
    private int mColor;

    public CodeSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getCodeBgColor();
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return text.contains("`") ? Pattern.compile(PATTERN).matcher(text).matches() : false;
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        return CodeSyntax.replace(ssb, "\\`", CharacterProtector.getKeyEncode());
    }

    @Override
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        String text = ssb.toString();
        return this.parse(text, ssb);
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
        CodeSyntax.replace(ssb, CharacterProtector.getKeyEncode(), "\\`");
    }

    @NonNull
    private SpannableStringBuilder parse(@NonNull String text, @NonNull SpannableStringBuilder ssb) {
        SpannableStringBuilder tmp = new SpannableStringBuilder();
        String tmpTotal = text;
        while (true) {
            int positionHeader;
            if ((positionHeader = this.findPosition(tmpTotal, ssb, tmp)) == -1) {
                tmp.append((CharSequence)tmpTotal.substring(0, tmpTotal.length()));
                break;
            }
            tmp.append((CharSequence)tmpTotal.substring(0, positionHeader));
            int index = tmp.length();
            tmpTotal = tmpTotal.substring(positionHeader + "`".length(), tmpTotal.length());
            int positionFooter = this.findPosition(tmpTotal, ssb, tmp);
            if (positionFooter == -1) {
                tmp.append((CharSequence)"`");
                tmp.append((CharSequence)tmpTotal.substring(0, tmpTotal.length()));
                break;
            }
            ssb.delete(tmp.length(), tmp.length() + "`".length());
            tmp.append((CharSequence)tmpTotal.substring(0, positionFooter));
            ssb.setSpan((Object)new MDCodeSpan(this.mColor), index, tmp.length(), 33);
            ssb.setSpan((Object)new TypefaceSpan("monospace"), index, tmp.length(), 33);
            ssb.delete(tmp.length(), tmp.length() + "`".length());
            tmpTotal = tmpTotal.substring(positionFooter + "`".length(), tmpTotal.length());
        }
        return ssb;
    }

    private int findPosition(@NonNull String tmpTotal, @NonNull SpannableStringBuilder ssb, @NonNull SpannableStringBuilder tmp) {
        String tmpTmpTotal = tmpTotal;
        int position = tmpTmpTotal.indexOf("`");
        if (position == -1) {
            return -1;
        }
        if (SyntaxUtils.existHyperLinkSyntax(ssb, tmp.length() + position, "`".length()) || SyntaxUtils.existImageSyntax(ssb, tmp.length() + position, "`".length())) {
            StringBuilder sb = new StringBuilder(tmpTmpTotal.substring(0, position)).append("$").append(tmpTmpTotal.substring(position + "`".length(), tmpTmpTotal.length()));
            return this.findPosition(sb.toString(), ssb, tmp);
        }
        return position;
    }
}

