/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Pair;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.prettify.PrettifyHighLighter;
import com.yydcdut.markdown.span.MDCodeBlockSpan;
import com.yydcdut.markdown.syntax.Syntax;
import com.yydcdut.markdown.utils.SyntaxUtils;
import com.yydcdut.markdown.utils.Utils;
import java.util.ArrayList;
import java.util.List;

class CodeBlockSyntax
implements Syntax {
    private int mBackgroundColor;
    private int mTextColor;
    private int mIndentedSize;
    private PrettifyHighLighter mPrettifyHighLighter;

    public CodeBlockSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        this.mBackgroundColor = markdownConfiguration.getTheme().getBackgroundColor();
        this.mIndentedSize = markdownConfiguration.getTheme().getIndentedSize();
        this.mPrettifyHighLighter = new PrettifyHighLighter(markdownConfiguration);
        this.mTextColor = markdownConfiguration.getTheme().getPlainTextColor();
    }

    @Override
    public boolean isMatch(@NonNull CharSequence charSequence) {
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return false;
        }
        return Utils.find(charSequence.toString(), "```").size() > 0;
    }

    @Override
    @NonNull
    public CharSequence format(@NonNull CharSequence charSequence) {
        if (!(charSequence instanceof SpannableStringBuilder)) {
            return charSequence;
        }
        SpannableStringBuilder ssb = (SpannableStringBuilder)charSequence;
        String text = charSequence.toString();
        List<Pair<Integer, Integer>> list = Utils.find(text, "```");
        for (int i = list.size() - 1; i >= 0; --i) {
            int position;
            int j;
            Pair<Integer, Integer> pair = list.get(i);
            int start = (Integer)pair.first;
            int end = (Integer)pair.second;
            List<Integer> middleList = Utils.getNewLineCharPosition(ssb, start, end);
            String language = "";
            if (middleList.size() > 0) {
                language = ssb.subSequence(start, middleList.get(0).intValue()).toString().replace("```", "").replace("\n", "");
            }
            int current = middleList.get(0) + 1;
            for (j = 1; j < middleList.size(); ++j) {
                position = middleList.get(j);
                if (position == current) {
                    ssb.replace(position - 1, position, (CharSequence)" ");
                }
                ssb.setSpan((Object)new MDCodeBlockSpan(this.mBackgroundColor, language, j == 1, j == middleList.size() - 1, ssb.subSequence(current, position).toString()), current, position, 33);
                SyntaxUtils.marginSSBLeft(ssb, this.mIndentedSize, current, position);
                current = position + 1;
            }
            if (!TextUtils.equals((CharSequence)"", (CharSequence)language)) {
                this.mPrettifyHighLighter.highLight(language, ssb, start, end);
            } else {
                current = middleList.get(0) + 1;
                for (j = 1; j < middleList.size(); ++j) {
                    position = middleList.get(j);
                    ssb.setSpan((Object)new ForegroundColorSpan(this.mTextColor), current, position, 33);
                    current = position + 1;
                }
            }
            ssb.delete(end, end + "```".length() + (end + "```".length() >= ssb.length() ? 0 : 1));
            ssb.delete(start, Utils.findNextNewLineChar((CharSequence)ssb, start) + 1);
        }
        return ssb;
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        return new ArrayList<EditToken>();
    }
}

