/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.style.AlignmentSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.CharacterProtector;

class CenterAlignSyntax
extends TextSyntaxAdapter {
    public CenterAlignSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return text.startsWith("[") && text.endsWith("]");
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        return CenterAlignSyntax.replace(ssb, "\\]", CharacterProtector.getKeyEncode1());
    }

    @Override
    @NonNull
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        ssb.delete(0, 1).delete(ssb.length() - 1, ssb.length());
        ssb.setSpan((Object)new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER), 0, ssb.length(), 33);
        return ssb;
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
        CenterAlignSyntax.replace(ssb, CharacterProtector.getKeyEncode1(), "\\]");
    }
}

