/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.CharacterProtector;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.regex.Pattern;

class BoldSyntax
extends TextSyntaxAdapter {
    private static final String PATTERN_ASTERISK = ".*[\\*]{2}.*[\\*]{2}.*";
    private static final String PATTERN_UNDERLINE = ".*[_]{2}.*[_]{2}.*";
    private boolean isContainsAsterisk;
    private boolean isContainsUnderline;

    public BoldSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
    }

    @Override
    boolean isMatch(@NonNull String text) {
        if (!text.contains("**") && !text.contains("__")) {
            return false;
        }
        Pattern pattern = Pattern.compile(PATTERN_ASTERISK);
        this.isContainsAsterisk = pattern.matcher(text).matches();
        pattern = Pattern.compile(PATTERN_UNDERLINE);
        this.isContainsUnderline = pattern.matcher(text).matches();
        return this.isContainsAsterisk | this.isContainsUnderline;
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        boolean isHandledBackSlash = false;
        if (this.isContainsAsterisk) {
            isHandledBackSlash |= BoldSyntax.replace(ssb, "\\*", CharacterProtector.getKeyEncode());
        }
        if (this.isContainsUnderline) {
            isHandledBackSlash |= BoldSyntax.replace(ssb, "\\_", CharacterProtector.getKeyEncode1());
        }
        return isHandledBackSlash;
    }

    @Override
    @NonNull
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        if (this.isContainsAsterisk) {
            ssb = SyntaxUtils.parseBoldAndItalic("**", ssb, new StyleSpan(1));
        }
        if (this.isContainsUnderline) {
            ssb = SyntaxUtils.parseBoldAndItalic("__", ssb, new StyleSpan(1));
        }
        return ssb;
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
        if (this.isContainsAsterisk) {
            BoldSyntax.replace(ssb, CharacterProtector.getKeyEncode(), "\\*");
        }
        if (this.isContainsUnderline) {
            BoldSyntax.replace(ssb, CharacterProtector.getKeyEncode1(), "\\_");
        }
    }
}

