/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.style.RelativeSizeSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.span.MDQuoteBackgroundSpan;
import com.yydcdut.markdown.span.MDQuoteSpan;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.List;

class BlockQuotesSyntax
extends TextSyntaxAdapter {
    private final float mRelativeSize;
    private final List<Integer> bgColorList;
    private int mColor;

    public BlockQuotesSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getBlockQuotesLineColor();
        this.mRelativeSize = markdownConfiguration.getBlockQuoteRelativeSize();
        this.bgColorList = markdownConfiguration.getBlockQuoteBgColor();
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return text.startsWith("> ");
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        return false;
    }

    @Override
    @NonNull
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        int i;
        int nested = BlockQuotesSyntax.calculateNested(ssb.toString());
        if (nested == 0) {
            return ssb;
        }
        for (i = 0; i < ssb.length() && (ssb.charAt(i) == '>' || ssb.charAt(i) == ' '); ++i) {
        }
        int number = i / 2;
        for (int n = 0; n < number; ++n) {
            ssb.replace(2 * n, 2 * (n + 1), (CharSequence)"  ");
        }
        ssb.setSpan((Object)new MDQuoteSpan(this.mColor, nested), 0, ssb.length(), 131105);
        ssb.setSpan((Object)new MDQuoteBackgroundSpan(nested, this.bgColorList), 0, ssb.length(), 65569);
        if (this.mRelativeSize != 1.0f) {
            ssb.setSpan((Object)new RelativeSizeSpan(this.mRelativeSize), 0, ssb.length(), 33);
        }
        SyntaxUtils.marginSSBLeft(ssb, 32);
        return ssb;
    }

    private static int calculateNested(@NonNull String text) {
        int nested = 0;
        int i = 0;
        while (i < text.length() && text.charAt(i) == '>') {
            ++nested;
            ++i;
            while (i < text.length() && text.charAt(i) == ' ') {
                ++i;
            }
        }
        return nested;
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
    }
}

