/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.text;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.syntax.text.TextSyntaxAdapter;

class BackslashSyntax
extends TextSyntaxAdapter {
    public BackslashSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
    }

    @Override
    boolean isMatch(@NonNull String text) {
        return text.contains("\\*") || text.contains("\\_") || text.contains("\\]") || text.contains("\\[") || text.contains("\\]") || text.contains("\\[") || text.contains("\\]") || text.contains("\\)") || text.contains("\\!") || text.contains("\\]") || text.contains("\\)") || text.contains("\\`") || text.contains("\\*") || text.contains("\\_") || text.contains("\\~");
    }

    @Override
    @NonNull
    boolean encode(@NonNull SpannableStringBuilder ssb) {
        return false;
    }

    @Override
    @NonNull
    SpannableStringBuilder format(@NonNull SpannableStringBuilder ssb) {
        BackslashSyntax.replace(ssb, "\\*", "*");
        BackslashSyntax.replace(ssb, "\\_", "_");
        BackslashSyntax.replace(ssb, "\\]", "]");
        BackslashSyntax.replace(ssb, "\\[", "[");
        BackslashSyntax.replace(ssb, "\\]", "]");
        BackslashSyntax.replace(ssb, "\\[", "[");
        BackslashSyntax.replace(ssb, "\\]", "]");
        BackslashSyntax.replace(ssb, "\\)", ")");
        BackslashSyntax.replace(ssb, "\\!", "!");
        BackslashSyntax.replace(ssb, "\\]", "]");
        BackslashSyntax.replace(ssb, "\\)", ")");
        BackslashSyntax.replace(ssb, "\\`", "`");
        BackslashSyntax.replace(ssb, "\\*", "*");
        BackslashSyntax.replace(ssb, "\\_", "_");
        BackslashSyntax.replace(ssb, "\\~", "~");
        return ssb;
    }

    @Override
    @NonNull
    void decode(@NonNull SpannableStringBuilder ssb) {
    }
}

