/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.text.Editable;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDUnOrderListSpan;
import com.yydcdut.markdown.syntax.edit.EditSyntaxAdapter;
import com.yydcdut.markdown.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class UnOrderListSyntax
extends EditSyntaxAdapter {
    private int mColor;

    public UnOrderListSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getUnOrderListColor();
    }

    @Override
    @NonNull
    @SuppressLint(value={"WrongConstant"})
    public List<EditToken> format(@NonNull Editable editable) {
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        ArrayList<String> matchList0 = new ArrayList<String>();
        ArrayList<String> matchList1 = new ArrayList<String>();
        ArrayList<String> matchList2 = new ArrayList<String>();
        StringBuilder content = new StringBuilder((CharSequence)editable);
        this.replaceTodo(content);
        Pattern p0 = Pattern.compile("^( *)(\\+ )(.*?)$", 8);
        Matcher m0 = p0.matcher(content);
        while (m0.find()) {
            matchList0.add(m0.group());
        }
        Pattern p1 = Pattern.compile("^( *)(\\- )(.*?)$", 8);
        Matcher m1 = p1.matcher(content);
        while (m1.find()) {
            matchList1.add(m1.group());
        }
        Pattern p2 = Pattern.compile("^( *)(\\* )(.*?)$", 8);
        Matcher m2 = p2.matcher(content);
        while (m2.find()) {
            matchList2.add(m2.group());
        }
        this.replace(matchList0, 2, content, editTokenList);
        this.replace(matchList1, 1, content, editTokenList);
        this.replace(matchList2, 0, content, editTokenList);
        return editTokenList;
    }

    private void replace(List<String> matchList, int type, StringBuilder content, List<EditToken> editTokenList) {
        for (String match : matchList) {
            int index = content.indexOf(match);
            int length = match.length();
            int nested = this.calculateNested(match);
            editTokenList.add(new EditToken((Object)new MDUnOrderListSpan(10, this.mColor, nested, type), index, index + length, 18));
            content.replace(index, index + length, Utils.getPlaceHolder(match));
        }
    }

    private int calculateNested(String text) {
        if (text.length() < 2) {
            return -1;
        }
        int nested = 0;
        while ((nested + 1) * " ".length() <= text.length()) {
            String sub = text.substring(nested * " ".length(), (nested + 1) * " ".length());
            if (" ".equals(sub)) {
                ++nested;
                continue;
            }
            return nested;
        }
        return nested;
    }

    private void replaceTodo(StringBuilder stringBuilder) {
        int index0;
        while ((index0 = stringBuilder.indexOf("- [x]")) != -1) {
            stringBuilder.replace(index0, index0 + "- [x]".length(), "     ");
        }
        while ((index0 = stringBuilder.indexOf("- [X]")) != -1) {
            stringBuilder.replace(index0, index0 + "- [X]".length(), "     ");
        }
        while ((index0 = stringBuilder.indexOf("- [ ]")) != -1) {
            stringBuilder.replace(index0, index0 + "- [ ]".length(), "     ");
        }
        while ((index0 = stringBuilder.indexOf("* [x]")) != -1) {
            stringBuilder.replace(index0, index0 + "* [x]".length(), "     ");
        }
        while ((index0 = stringBuilder.indexOf("* [x]")) != -1) {
            stringBuilder.replace(index0, index0 + "* [x]".length(), "     ");
        }
        while ((index0 = stringBuilder.indexOf("* [ ]")) != -1) {
            stringBuilder.replace(index0, index0 + "* [ ]".length(), "     ");
        }
    }
}

