/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.TextUtils;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDOrderListSpan;
import com.yydcdut.markdown.syntax.edit.EditSyntaxAdapter;
import com.yydcdut.markdown.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class OrderListSyntax
extends EditSyntaxAdapter {
    private static final String PATTERN = "^( *)(\\d+)\\. (.*?)$";

    public OrderListSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        Pattern p = Pattern.compile(PATTERN, 8);
        StringBuilder content = new StringBuilder((CharSequence)editable);
        Matcher m = p.matcher(content);
        ArrayList<String> matchList = new ArrayList<String>();
        while (m.find()) {
            matchList.add(m.group());
        }
        for (String match : matchList) {
            int index = OrderListSyntax.findTrueIndex(match, content);
            int length = match.length();
            int nested = this.calculateNested(match);
            int number = this.calculateNumber(match, nested);
            editTokenList.add(new EditToken((Object)new MDOrderListSpan(10, nested, number), index, index + length, 18));
            content.replace(index, index + length, Utils.getPlaceHolder(match));
        }
        return editTokenList;
    }

    private int calculateNested(String text) {
        if (text.length() < 2) {
            return -1;
        }
        int nested = 0;
        while ((nested + 1) * " ".length() <= text.length()) {
            String sub = text.substring(nested * " ".length(), (nested + 1) * " ".length());
            if (" ".equals(sub)) {
                ++nested;
                continue;
            }
            return nested;
        }
        return nested;
    }

    private int calculateNumber(@NonNull String text, int nested) {
        if (text.length() < 3) {
            return -1;
        }
        int number = -1;
        String s = text.substring(nested * " ".length(), text.length());
        if (TextUtils.isDigitsOnly((CharSequence)s.substring(0, 1))) {
            number = Integer.parseInt(s.substring(0, 1));
            for (int i = 1; i < s.length(); ++i) {
                if (!TextUtils.isDigitsOnly((CharSequence)s.substring(i, i + 1))) {
                    return number;
                }
                number = number * 10 + Integer.parseInt(s.substring(i, i + 1));
            }
        } else {
            return number;
        }
        return number;
    }

    private static int findTrueIndex(String match, StringBuilder content) {
        int length;
        int index = content.indexOf(match);
        if (index + (length = match.length()) >= content.length()) {
            return index;
        }
        char c = content.charAt(index + length);
        if (c == '\n') {
            return index;
        }
        content.replace(index, index + length, Utils.getPlaceHolder(match));
        return OrderListSyntax.findTrueIndex(match, content);
    }
}

