/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.support.annotation.NonNull;
import android.text.Editable;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.span.MDHorizontalRulesSpan;
import com.yydcdut.markdown.syntax.edit.EditSyntaxAdapter;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.ArrayList;
import java.util.List;

class HorizontalRulesSyntax
extends EditSyntaxAdapter
implements SyntaxUtils.OnWhatSpanCallback {
    private static final String PATTERN_ASTERISK = "^\\*{3,}$";
    private static final String PATTERN_HYPHEN = "^\\-{3,}$";
    private int mColor;
    private int mHeight;

    public HorizontalRulesSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getHorizontalRulesColor();
        this.mHeight = markdownConfiguration.getHorizontalRulesHeight();
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        editTokenList.addAll(SyntaxUtils.parse(editable, PATTERN_ASTERISK, (SyntaxUtils.OnWhatSpanCallback)this));
        editTokenList.addAll(SyntaxUtils.parse(editable, PATTERN_HYPHEN, (SyntaxUtils.OnWhatSpanCallback)this));
        return editTokenList;
    }

    @Override
    public Object whatSpan() {
        return new MDHorizontalRulesSpan(this.mColor, this.mHeight);
    }
}

