/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.TextUtils;
import android.text.style.RelativeSizeSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.syntax.edit.EditSyntaxAdapter;
import com.yydcdut.markdown.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HeaderSyntax
extends EditSyntaxAdapter {
    private static final String PATTERN = "^(#{1,6})( )(.*?)$";
    private static final String PATTERN_WITH_CENTER_ALIGN = "^\\[(#{1,6}( )(.*?)\\]$)";
    private float mHeader1RelativeSize;
    private float mHeader2RelativeSize;
    private float mHeader3RelativeSize;
    private float mHeader4RelativeSize;
    private float mHeader5RelativeSize;
    private float mHeader6RelativeSize;

    public HeaderSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mHeader1RelativeSize = markdownConfiguration.getHeader1RelativeSize();
        this.mHeader2RelativeSize = markdownConfiguration.getHeader2RelativeSize();
        this.mHeader3RelativeSize = markdownConfiguration.getHeader3RelativeSize();
        this.mHeader4RelativeSize = markdownConfiguration.getHeader4RelativeSize();
        this.mHeader5RelativeSize = markdownConfiguration.getHeader5RelativeSize();
        this.mHeader6RelativeSize = markdownConfiguration.getHeader6RelativeSize();
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        ArrayList<EditToken> editTokenList = new ArrayList<EditToken>();
        StringBuilder content = new StringBuilder((CharSequence)editable);
        Matcher m = Pattern.compile(PATTERN, 8).matcher(content);
        ArrayList<String> matchList = new ArrayList<String>();
        HashMap<String, Integer> specialMap = new HashMap<String, Integer>();
        while (m.find()) {
            String matchString = m.group();
            if (HeaderSyntax.matchSpecial(matchString)) {
                HeaderSyntax.addSpecial(matchString, specialMap);
                continue;
            }
            matchList.add(matchString);
        }
        Matcher m2 = Pattern.compile(PATTERN_WITH_CENTER_ALIGN, 8).matcher(content);
        while (m2.find()) {
            String matchString = m2.group();
            if (HeaderSyntax.matchSpecial(matchString)) {
                HeaderSyntax.addSpecial(matchString, specialMap);
                continue;
            }
            matchList.add(matchString);
        }
        for (String match : matchList) {
            this.replace(content, match, editTokenList);
        }
        this.replaceSpecial(specialMap, content, editTokenList);
        return editTokenList;
    }

    private Object getSpan(String match) {
        if (match.startsWith("[")) {
            return this.getRealSpan(match);
        }
        return this.getRealSpan(match);
    }

    private Object getRealSpan(String match) {
        if (match.contains("###### ")) {
            return new RelativeSizeSpan(this.mHeader6RelativeSize);
        }
        if (match.contains("##### ")) {
            return new RelativeSizeSpan(this.mHeader5RelativeSize);
        }
        if (match.contains("#### ")) {
            return new RelativeSizeSpan(this.mHeader4RelativeSize);
        }
        if (match.contains("### ")) {
            return new RelativeSizeSpan(this.mHeader3RelativeSize);
        }
        if (match.contains("## ")) {
            return new RelativeSizeSpan(this.mHeader2RelativeSize);
        }
        if (match.contains("# ")) {
            return new RelativeSizeSpan(this.mHeader1RelativeSize);
        }
        return new RelativeSizeSpan(1.0f);
    }

    private static boolean matchSpecial(String match) {
        return TextUtils.equals((CharSequence)match, (CharSequence)"# ") || TextUtils.equals((CharSequence)match, (CharSequence)"## ") || TextUtils.equals((CharSequence)match, (CharSequence)"### ") || TextUtils.equals((CharSequence)match, (CharSequence)"#### ") || TextUtils.equals((CharSequence)match, (CharSequence)"##### ") || TextUtils.equals((CharSequence)match, (CharSequence)"###### ");
    }

    private static void addSpecial(String match, Map<String, Integer> map) {
        Integer integer = map.get(match);
        if (integer == null) {
            map.put(match, 1);
        } else {
            map.remove(match);
            integer = integer + 1;
            map.put(match, integer);
        }
    }

    private void replace(StringBuilder content, String match, List<EditToken> editTokenList) {
        int index = content.indexOf(match);
        int length = match.length();
        editTokenList.add(new EditToken(this.getSpan(match), index, index + length, 34));
        content.replace(index, index + length, Utils.getPlaceHolder(match));
    }

    private void replaceSpecial(Map<String, Integer> specialMap, StringBuilder content, List<EditToken> editTokenList) {
        Integer num0Int;
        Integer num1Int;
        Integer num2Int;
        Integer num3Int;
        Integer num4Int;
        Integer num5Int = specialMap.get("###### ");
        if (num5Int != null && num5Int > 0) {
            this.replace(content, "###### ", editTokenList);
        }
        if ((num4Int = specialMap.get("##### ")) != null && num4Int > 0) {
            this.replace(content, "##### ", editTokenList);
        }
        if ((num3Int = specialMap.get("#### ")) != null && num3Int > 0) {
            this.replace(content, "#### ", editTokenList);
        }
        if ((num2Int = specialMap.get("### ")) != null && num2Int > 0) {
            this.replace(content, "### ", editTokenList);
        }
        if ((num1Int = specialMap.get("## ")) != null && num1Int > 0) {
            this.replace(content, "## ", editTokenList);
        }
        if ((num0Int = specialMap.get("# ")) != null && num0Int > 0) {
            this.replace(content, "# ", editTokenList);
        }
    }
}

