/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.support.annotation.NonNull;
import android.text.Editable;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.syntax.Syntax;
import com.yydcdut.markdown.syntax.SyntaxFactory;
import com.yydcdut.markdown.syntax.edit.BlockQuotesSyntax;
import com.yydcdut.markdown.syntax.edit.BoldSyntax;
import com.yydcdut.markdown.syntax.edit.CenterAlignSyntax;
import com.yydcdut.markdown.syntax.edit.CodeBlockSyntax;
import com.yydcdut.markdown.syntax.edit.CodeSyntax;
import com.yydcdut.markdown.syntax.edit.HeaderSyntax;
import com.yydcdut.markdown.syntax.edit.HorizontalRulesSyntax;
import com.yydcdut.markdown.syntax.edit.ItalicSyntax;
import com.yydcdut.markdown.syntax.edit.NormalSyntax;
import com.yydcdut.markdown.syntax.edit.OrderListSyntax;
import com.yydcdut.markdown.syntax.edit.StrikeThroughSyntax;
import com.yydcdut.markdown.syntax.edit.UnOrderListSyntax;
import java.util.ArrayList;
import java.util.List;

public class EditFactory
implements SyntaxFactory {
    private List<Syntax> mSyntaxList;
    private MarkdownConfiguration mMarkdownConfiguration;

    private EditFactory() {
    }

    public static SyntaxFactory create() {
        return new EditFactory();
    }

    @Override
    public Syntax getHorizontalRulesSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new HorizontalRulesSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getBlockQuotesSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new BlockQuotesSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getTodoSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new NormalSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getTodoDoneSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new NormalSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getOrderListSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new OrderListSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getUnOrderListSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new UnOrderListSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getCenterAlignSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new CenterAlignSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getHeaderSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new HeaderSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getBoldSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new BoldSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getItalicSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new ItalicSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getCodeSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new CodeSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getStrikeThroughSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new StrikeThroughSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getFootnoteSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new NormalSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getImageSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new NormalSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getHyperLinkSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new NormalSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getCodeBlockSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new CodeBlockSyntax(markdownConfiguration);
    }

    @Override
    public Syntax getBackslashSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        return new NormalSyntax(markdownConfiguration);
    }

    private void init(MarkdownConfiguration markdownConfiguration) {
        this.mMarkdownConfiguration = markdownConfiguration;
        this.mSyntaxList = new ArrayList<Syntax>();
        this.mSyntaxList.add(this.getBoldSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getItalicSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getStrikeThroughSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getCodeSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getCenterAlignSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getHeaderSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getBlockQuotesSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getCodeBlockSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getHorizontalRulesSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getOrderListSyntax(this.mMarkdownConfiguration));
        this.mSyntaxList.add(this.getUnOrderListSyntax(this.mMarkdownConfiguration));
    }

    @Override
    @NonNull
    public CharSequence parse(@NonNull CharSequence charSequence, @NonNull MarkdownConfiguration markdownConfiguration) {
        if (!(charSequence instanceof Editable)) {
            return charSequence;
        }
        if (markdownConfiguration == null) {
            return charSequence;
        }
        if (this.mSyntaxList == null || this.mMarkdownConfiguration == null || this.mMarkdownConfiguration != markdownConfiguration) {
            this.init(markdownConfiguration);
        }
        Editable editable = (Editable)charSequence;
        ArrayList<EditToken> list = new ArrayList<EditToken>();
        for (Syntax syntax : this.mSyntaxList) {
            list.addAll(syntax.format(editable));
        }
        Editable newEditable = Editable.Factory.getInstance().newEditable((CharSequence)editable.toString());
        for (EditToken editToken : list) {
            newEditable.setSpan(editToken.getSpan(), editToken.getStart(), editToken.getEnd(), editToken.getFlag());
        }
        return newEditable;
    }
}

