/*
 * Decompiled with CFR 0.152.
 */
package com.yydcdut.markdown.syntax.edit;

import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.style.BackgroundColorSpan;
import com.yydcdut.markdown.MarkdownConfiguration;
import com.yydcdut.markdown.live.EditToken;
import com.yydcdut.markdown.syntax.edit.EditSyntaxAdapter;
import com.yydcdut.markdown.utils.SyntaxUtils;
import java.util.List;

class CodeSyntax
extends EditSyntaxAdapter
implements SyntaxUtils.OnWhatSpanCallback {
    private static final String PATTERN = "(`)(.*?)(`)";
    private int mColor;

    public CodeSyntax(@NonNull MarkdownConfiguration markdownConfiguration) {
        super(markdownConfiguration);
        this.mColor = markdownConfiguration.getCodeBgColor();
    }

    @Override
    @NonNull
    public List<EditToken> format(@NonNull Editable editable) {
        return SyntaxUtils.parse(editable, PATTERN, "```", this);
    }

    @Override
    public Object whatSpan() {
        return new BackgroundColorSpan(this.mColor);
    }
}

